/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;

public class UploadFileIterator {
    private int _maxBufLen = 1024000;
    private InputStream _iStream;
    private byte[] _buf;
    private int _bufLen;
    private File _file = null;

    public UploadFileIterator(File file) throws DeploymentRuntimeException {
        try {
            this._iStream = new FileInputStream(file);
            this._file = file;
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("UploadFileIterator error", e);
        }
        long fileLen = file.length();
        int tmplen = (int)fileLen;
        if ((long)tmplen != fileLen) {
            this.init(-1);
        } else {
            this.init((int)fileLen);
        }
    }

    public UploadFileIterator(InputStream iStream) throws DeploymentRuntimeException {
        this._iStream = iStream;
        this.init(-1);
    }

    public boolean hasMoreBytes() throws DeploymentRuntimeException {
        try {
            return this._iStream != null && this._iStream.available() > 0;
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException(e);
        }
    }

    public byte[] getBytes() throws DeploymentRuntimeException {
        try {
            int bytes = this._iStream.read(this._buf);
            if (bytes < this._bufLen) {
                byte[] newbuf = new byte[bytes];
                for (int i = 0; i < bytes; ++i) {
                    newbuf[i] = this._buf[i];
                }
                this._buf = newbuf;
            }
            return this._buf;
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException(e);
        }
    }

    public void setUploadBufLen(int len) {
        if (len > this._maxBufLen) {
            this._bufLen = len;
            this._buf = new byte[this._bufLen];
        }
    }

    public void close() {
        if (this._file != null) {
            try {
                this._iStream.close();
            }
            catch (IOException e) {
                System.err.println("ERROR: unable to close UploadFileIterator for " + this._file.getAbsolutePath() + " : " + e.getMessage());
            }
        }
    }

    private void init(int fileLen) {
        try {
            int buflen;
            String bufstr = System.getProperty("upload.buflen");
            if (bufstr != null && (buflen = Integer.parseInt(bufstr)) > this._maxBufLen) {
                this._maxBufLen = buflen;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._bufLen = fileLen > 0 && this._maxBufLen > fileLen ? fileLen : this._maxBufLen;
        this._buf = new byte[this._bufLen];
    }
}

