/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteBindingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteBindingType;

public class WebSiteBindingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_WEB_SITE_BINDING_MENU_STRING = "Add Web Site Binding";
    private JMenuItem _addWebSiteBindingMenuItem;
    private WebSiteBindingType[] webSiteBindingsType = new WebSiteBindingType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public WebSiteBindingsTreeNode(ConfigTreeNode rootNode, MultipleType webSiteBindings) {
        super(webSiteBindings);
        this.setRootNode(rootNode);
        this._parentBean = webSiteBindings.getConfigParent();
        this._addWebSiteBindingMenuItem = new JMenuItem(ADD_WEB_SITE_BINDING_MENU_STRING);
        this._addWebSiteBindingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addWebSiteBindingMenuItem.setFont(WebSiteBindingsTreeNode.getFont());
        this._addWebSiteBindingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addWebSiteBindingMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getWebSiteBindings", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addWebSiteBinding", WebSiteBindingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeWebSiteBinding", WebSiteBindingType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Web Site Bindings";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            WebSiteBindingType[] webSiteBindings = (WebSiteBindingType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (webSiteBindings != null) {
                for (int i = 0; i < webSiteBindings.length; ++i) {
                    WebSiteBindingType webSiteBinding = webSiteBindings[i];
                    if (webSiteBinding == null) continue;
                    WebSiteBindingTreeNode webSiteBindingTreeNode = new WebSiteBindingTreeNode(this.getRootNode(), webSiteBinding);
                    this.addChild(webSiteBindingTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            WebSiteBindingType newWebSiteBinding;
            if (event.getActionCommand().equals(ADD_WEB_SITE_BINDING_MENU_STRING) && this.showAddDialog(newWebSiteBinding = new WebSiteBindingType(this._parentBean), ADD_WEB_SITE_BINDING_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newWebSiteBinding);
                WebSiteBindingTreeNode newNode = new WebSiteBindingTreeNode(this, newWebSiteBinding);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof WebSiteBindingTreeNode) {
            try {
                WebSiteBindingType webSiteBinding = (WebSiteBindingType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, webSiteBinding);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

