/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTree;
import oracle.oc4j.admin.deploy.spi.xml.EjbTransportLoginConfigType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderDescriptionConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.WebServiceDescriptionConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.WebServicesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteEndpointType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServicesConfigBean
extends ConfigBeanNode {
    protected String _contextRoot = null;
    protected String _deploymentVersion = null;
    protected WebSiteEndpointType _webSite = null;
    protected ProviderDescriptionConfigBean[] _providerDescriptions = null;
    protected EjbTransportLoginConfigType _ejbTransportLoginConfig = null;

    public WebServicesConfigBean(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public WebServicesConfigBean(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void setContextRoot(String contextRoot) throws ConfigurationException {
        String oldValue = this._contextRoot;
        this._contextRoot = contextRoot;
        this.firePropertyChange("contextRoot", oldValue, this._contextRoot);
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    public String defaultContextRoot() {
        return "";
    }

    public void setDeploymentVersion(String deploymentVersion) throws ConfigurationException {
        String oldValue = this._deploymentVersion;
        this._deploymentVersion = deploymentVersion;
        this.firePropertyChange("deploymentVersion", oldValue, this._deploymentVersion);
    }

    public String getDeploymentVersion() {
        return this._deploymentVersion;
    }

    public String defaultDeploymentVersion() {
        return "";
    }

    public void setProviderDescriptions(ProviderDescriptionConfigBean[] providerDescriptions) throws ConfigurationException {
        ProviderDescriptionConfigBean[] oldValue = this._providerDescriptions;
        this._providerDescriptions = providerDescriptions;
        this.firePropertyChange("providerDescriptions", oldValue, this._providerDescriptions);
    }

    public ProviderDescriptionConfigBean[] getProviderDescriptions() {
        return this._providerDescriptions;
    }

    public ProviderDescriptionConfigBean[] defaultProviderDescriptions() {
        try {
            return new ProviderDescriptionConfigBean[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addProviderDescriptions() throws ConfigurationException {
        if (this._providerDescriptions != null) {
            return;
        }
        ProviderDescriptionConfigBean[] providerDescriptions = new ProviderDescriptionConfigBean[]{new ProviderDescriptionConfigBean(this, null)};
        this.setProviderDescriptions(providerDescriptions);
    }

    public void removeProviderDescriptions() throws ConfigurationException {
        if (this._providerDescriptions == null) {
            return;
        }
        this.setProviderDescriptions(null);
    }

    public void addProviderDescription(ProviderDescriptionConfigBean providerDescription) throws ConfigurationException {
        providerDescription.setParent(this);
        int existingProviderDescriptionsCnt = 0;
        if (this._providerDescriptions != null) {
            existingProviderDescriptionsCnt = this._providerDescriptions.length;
        }
        ProviderDescriptionConfigBean[] newProviderDescriptions = new ProviderDescriptionConfigBean[existingProviderDescriptionsCnt + 1];
        for (int n = 0; n < existingProviderDescriptionsCnt; ++n) {
            newProviderDescriptions[n] = this._providerDescriptions[n];
        }
        newProviderDescriptions[existingProviderDescriptionsCnt] = providerDescription;
        ProviderDescriptionConfigBean[] oldValue = this._providerDescriptions;
        this._providerDescriptions = newProviderDescriptions;
        this.firePropertyChange("providerDescriptions", oldValue, this._providerDescriptions);
    }

    public void removeProviderDescription(ProviderDescriptionConfigBean providerDescription) throws ConfigurationException {
        int existingProviderDescriptionsCnt = 0;
        if (this._providerDescriptions != null) {
            existingProviderDescriptionsCnt = this._providerDescriptions.length;
        }
        ProviderDescriptionConfigBean[] newProviderDescriptions = new ProviderDescriptionConfigBean[existingProviderDescriptionsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingProviderDescriptionsCnt; ++n) {
            if (providerDescription.equals(this._providerDescriptions[n])) continue;
            newProviderDescriptions[newIndex++] = this._providerDescriptions[n];
        }
        if (newProviderDescriptions.length == 0) {
            newProviderDescriptions = null;
        }
        ProviderDescriptionConfigBean[] oldValue = this._providerDescriptions;
        this._providerDescriptions = newProviderDescriptions;
        this.firePropertyChange("providerDescriptions", oldValue, this._providerDescriptions);
    }

    public EjbTransportLoginConfigType getEjbTransportLoginConfig() {
        return this._ejbTransportLoginConfig;
    }

    public void setEjbTransportLoginConfig(EjbTransportLoginConfigType ejbTransportLoginConfig) throws ConfigurationException {
        EjbTransportLoginConfigType oldValue = this._ejbTransportLoginConfig;
        this._ejbTransportLoginConfig = ejbTransportLoginConfig;
        this.firePropertyChange("ejbTransportLoginConfig", oldValue, this._ejbTransportLoginConfig);
    }

    public void addEjbTransportLoginConfig() throws ConfigurationException {
        if (this._ejbTransportLoginConfig != null) {
            return;
        }
        EjbTransportLoginConfigType ejbTransportLoginConfig = new EjbTransportLoginConfigType(this, null);
        this.setEjbTransportLoginConfig(ejbTransportLoginConfig);
    }

    public void removeEjbTransportLoginConfig() throws ConfigurationException {
        if (this._ejbTransportLoginConfig == null) {
            return;
        }
        this.setEjbTransportLoginConfig(null);
    }

    public EjbTransportLoginConfigType defaultEjbTransportLoginConfig() {
        try {
            return new EjbTransportLoginConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "oracle-webservices");
        XMLUtils.writeAttribute(out, indentation, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        XMLUtils.writeAttribute(out, indentation, "xsi:noNamespaceSchemaLocation", "http://xmlns.oracle.com/oracleas/schema/oracle-webservices-10_0.xsd");
        XMLUtils.writeAttribute(out, indentation, "deployment-version", this._deploymentVersion);
        XMLUtils.writeTagAttributeEnd(out, indentation, "oracle-webservices");
        if (this._webSite != null) {
            this._webSite.writeXML(out, indentation + "\t");
        }
        if (this._contextRoot != null && this._contextRoot.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "context-root", this._contextRoot);
        }
        WebServicesConfigBean.writeAll(this.getChildBean("webservice-description"), out, indentation + "\t");
        WebServicesConfigBean.writeXML(out, indentation + "\t", this._providerDescriptions);
        if (this.getEjbTransportLoginConfig() != null) {
            this.getEjbTransportLoginConfig().writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "oracle-webservices");
    }

    public void writeProviderDescriptionsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ProviderDescriptionConfigBean.writeXML(out, indentation, this._providerDescriptions);
    }

    private void init() throws ConfigurationException {
        this.setXpath("oracle-webservices");
        this._xpaths = new String[1];
        this._xpaths[0] = "webservice-description";
        this._configXpaths = new String[1];
        this._configXpaths[0] = "webservice-description";
        Vector<WebServiceDescriptionConfigBean> webServiceDesc = new Vector<WebServiceDescriptionConfigBean>();
        Vector<ProviderDescriptionConfigBean> providerDescriptions = new Vector<ProviderDescriptionConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "deployment-version");
            if (val != null && !val.trim().equals("")) {
                this.setDeploymentVersion(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("context-root")) {
                    this.setContextRoot(XMLUtils.getValue(node));
                    continue;
                }
                if (name.equals("webservice-description")) {
                    WebServiceDescriptionConfigBean webServiceDescBean = new WebServiceDescriptionConfigBean(this, node);
                    webServiceDesc.add(webServiceDescBean);
                    continue;
                }
                if (name.equals("web-site")) {
                    WebSiteEndpointType webSite = new WebSiteEndpointType(this, node);
                    this.setWebSite(webSite);
                    continue;
                }
                if (name.equals("provider-description")) {
                    ProviderDescriptionConfigBean providerDescription = new ProviderDescriptionConfigBean(this, node);
                    providerDescriptions.add(providerDescription);
                    continue;
                }
                if (!name.equals("ejb-transport-login-config")) continue;
                EjbTransportLoginConfigType ejbTransportLoginConfig = new EjbTransportLoginConfigType(this, node);
                this.setEjbTransportLoginConfig(ejbTransportLoginConfig);
            }
        }
        if (providerDescriptions.size() > 0) {
            this.setProviderDescriptions(providerDescriptions.toArray(new ProviderDescriptionConfigBean[0]));
        }
        this.recordXpathForBeans("webservice-description", webServiceDesc);
    }

    public ViewableJTree[] subTrees() {
        WebServicesTreeNode treeNode = new WebServicesTreeNode(this);
        treeNode.setTreePath(new TreePath(treeNode));
        ConfigTree tree = new ConfigTree(treeNode);
        treeNode.setTree(tree);
        return new ViewableJTree[]{tree};
    }

    public WebSiteEndpointType getWebSite() {
        return this._webSite;
    }

    public void setWebSite(WebSiteEndpointType webSite) throws ConfigurationException {
        this._webSite = webSite;
    }

    public void addWebSite() throws ConfigurationException {
        if (this._webSite != null) {
            return;
        }
        WebSiteEndpointType webSite = this.defaultWebSite();
        this.setWebSite(webSite);
    }

    public void removeWebSite() throws ConfigurationException {
        if (this._webSite == null) {
            return;
        }
        this.setWebSite(null);
    }

    public WebSiteEndpointType defaultWebSite() {
        return new WebSiteEndpointType(this, null);
    }
}

