/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.CmpFieldMappingType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValueMappingType
extends ConfigBeanNode {
    BooleanType _immutable = null;
    BooleanType _oldImmutable = null;
    String _type = null;
    CmpFieldMappingType _mapping = null;

    public ValueMappingType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public ValueMappingType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setImmutable(BooleanType immutable) throws ConfigurationException {
        this._immutable = immutable;
        this.firePropertyChange("immutable", this._oldImmutable, this._immutable);
        if (this._immutable != null) {
            if (this._oldImmutable == null) {
                this._oldImmutable = this.defaultImmutable();
            }
            this._oldImmutable.setValue(this._immutable.getValue());
        } else {
            this._oldImmutable = null;
        }
    }

    public BooleanType getImmutable() {
        return this._immutable;
    }

    public BooleanType defaultImmutable() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setType(String type) {
        String oldValue = this._type;
        this._type = type;
        this.firePropertyChange("type", oldValue, this._type);
    }

    public String getType() {
        return this._type;
    }

    public String defaultType() {
        return "";
    }

    public void setMapping(CmpFieldMappingType mapping) {
        CmpFieldMappingType oldValue = this._mapping;
        this._mapping = mapping;
        this.firePropertyChange("mapping", oldValue, this._mapping);
    }

    public CmpFieldMappingType getMapping() {
        return this._mapping;
    }

    public CmpFieldMappingType defaultMapping() {
        try {
            return new CmpFieldMappingType(this);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addMapping() throws ConfigurationException {
        if (this._mapping != null) {
            return;
        }
        CmpFieldMappingType mapping = new CmpFieldMappingType(this, null);
        this.setMapping(mapping);
    }

    public void removeMapping() throws ConfigurationException {
        if (this._mapping == null) {
            return;
        }
        this.setMapping(null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "value-mapping");
        XMLUtils.writeAttribute(out, indentation, "immutable", this._immutable);
        XMLUtils.writeAttribute(out, indentation, "type", this._type);
        XMLUtils.writeTagAttributeEnd(out, indentation, "value-mapping");
        if (this._mapping != null) {
            this._mapping.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "value-mapping");
    }

    private void init() throws ConfigurationException {
        this.setXpath("value-mapping");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "immutable");
            if (val != null && !val.trim().equals("")) {
                BooleanType immutable = this.defaultImmutable();
                immutable.setValue(val);
                this.setImmutable(immutable);
            }
            if ((val = XMLUtils.getAttribute(node, "type")) != null && !val.trim().equals("")) {
                this.setType(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("cmp-field-mapping")) continue;
                this.setMapping(new CmpFieldMappingType(this, node));
            }
        }
    }
}

