/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.InboundTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyConfigType;
import oracle.oc4j.admin.deploy.spi.xml.KeyStoreTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyStoreType;
import oracle.oc4j.admin.deploy.spi.xml.NonceConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NonceConfigType;
import oracle.oc4j.admin.deploy.spi.xml.OutboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.OutboundTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigPortType;

public class SecurityConfigPortTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SecurityConfigPortType _bean;
    private static final String ADD_KEY_STORE_MENU_STRING = "Add Key Store";
    private static final String SIGNATURE_KEY_TEXT = "Signature Key";
    private static final String ADD_SIGNATURE_KEY_MENU_STRING = "Add Signature Key";
    private static final String ENCRYPTION_KEY_TEXT = "Encryption Key";
    private static final String ADD_ENCRYPTION_KEY_MENU_STRING = "Add Encryption Key";
    private static final String ADD_NONCE_CONFIG_MENU_STRING = "Add Nonce Config";
    private static final String ADD_INBOUND_MENU_STRING = "Add Inbound";
    private static final String ADD_OUTBOUND_MENU_STRING = "Add Outbound";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_SECURITY_MENU_STRING = "Remove Security";
    private JMenuItem _addKeyStoreMenuItem;
    private JMenuItem _addSignatureKeyMenuItem;
    private JMenuItem _addEncryptionKeyMenuItem;
    private JMenuItem _addNonceConfigMenuItem;
    private JMenuItem _addInboundMenuItem;
    private JMenuItem _addOutboundMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeSecurityMenuItem;

    public SecurityConfigPortTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (SecurityConfigPortType)bean;
        this._addKeyStoreMenuItem = new JMenuItem(ADD_KEY_STORE_MENU_STRING);
        this._addKeyStoreMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addKeyStoreMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addKeyStoreMenuItem.addActionListener(this);
        if (this._bean.getKeyStore() != null) {
            this._addKeyStoreMenuItem.setEnabled(false);
        }
        this._addSignatureKeyMenuItem = new JMenuItem(ADD_SIGNATURE_KEY_MENU_STRING);
        this._addSignatureKeyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSignatureKeyMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addSignatureKeyMenuItem.addActionListener(this);
        if (this._bean.getSignatureKey() != null) {
            this._addSignatureKeyMenuItem.setEnabled(false);
        }
        this._addEncryptionKeyMenuItem = new JMenuItem(ADD_ENCRYPTION_KEY_MENU_STRING);
        this._addEncryptionKeyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addEncryptionKeyMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addEncryptionKeyMenuItem.addActionListener(this);
        if (this._bean.getEncryptionKey() != null) {
            this._addEncryptionKeyMenuItem.setEnabled(false);
        }
        this._addNonceConfigMenuItem = new JMenuItem(ADD_NONCE_CONFIG_MENU_STRING);
        this._addNonceConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNonceConfigMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addNonceConfigMenuItem.addActionListener(this);
        if (this._bean.getNonceConfig() != null) {
            this._addNonceConfigMenuItem.setEnabled(false);
        }
        this._addInboundMenuItem = new JMenuItem(ADD_INBOUND_MENU_STRING);
        this._addInboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addInboundMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addInboundMenuItem.addActionListener(this);
        if (this._bean.getInbound() != null) {
            this._addInboundMenuItem.setEnabled(false);
        }
        this._addOutboundMenuItem = new JMenuItem(ADD_OUTBOUND_MENU_STRING);
        this._addOutboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOutboundMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addOutboundMenuItem.addActionListener(this);
        if (this._bean.getOutbound() != null) {
            this._addOutboundMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeSecurityMenuItem = new JMenuItem(REMOVE_SECURITY_MENU_STRING);
        this._removeSecurityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSecurityMenuItem.setFont(SecurityConfigPortTreeNode.getFont());
        this._removeSecurityMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addKeyStoreMenuItem);
        this._popup.add(this._addSignatureKeyMenuItem);
        this._popup.add(this._addEncryptionKeyMenuItem);
        this._popup.add(this._addNonceConfigMenuItem);
        this._popup.add(this._addInboundMenuItem);
        this._popup.add(this._addOutboundMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeSecurityMenuItem);
    }

    public String viewHeaderString() {
        return "Security";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PropertyConfigBean[] properties;
        OutboundConfigType outbound;
        InboundConfigType inbound;
        NonceConfigType nonceConfig;
        KeyConfigType encryptionKey;
        KeyConfigType signatureKey;
        KeyStoreType keyStore = this._bean.getKeyStore();
        if (keyStore != null) {
            KeyStoreTreeNode keyStoreTreeNode = new KeyStoreTreeNode(this.getRootNode(), keyStore);
            this.addChild(keyStoreTreeNode);
        }
        if ((signatureKey = this._bean.getSignatureKey()) != null) {
            KeyConfigTreeNode signatureKeyTreeNode = new KeyConfigTreeNode(this.getRootNode(), signatureKey, SIGNATURE_KEY_TEXT);
            this.addChild(signatureKeyTreeNode);
        }
        if ((encryptionKey = this._bean.getEncryptionKey()) != null) {
            KeyConfigTreeNode encryptionKeyTreeNode = new KeyConfigTreeNode(this.getRootNode(), encryptionKey, ENCRYPTION_KEY_TEXT);
            this.addChild(encryptionKeyTreeNode);
        }
        if ((nonceConfig = this._bean.getNonceConfig()) != null) {
            NonceConfigTreeNode nonceConfigTreeNode = new NonceConfigTreeNode(this.getRootNode(), nonceConfig);
            this.addChild(nonceConfigTreeNode);
        }
        if ((inbound = this._bean.getInbound()) != null) {
            InboundTreeNode inboundTreeNode = new InboundTreeNode(this.getRootNode(), inbound);
            this.addChild(inboundTreeNode);
        }
        if ((outbound = this._bean.getOutbound()) != null) {
            OutboundTreeNode outboundTreeNode = new OutboundTreeNode(this.getRootNode(), outbound);
            this.addChild(outboundTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_KEY_STORE_MENU_STRING)) {
                KeyStoreType newKeyStore;
                if (this._bean.getKeyStore() == null && this.showAddDialog(newKeyStore = this._bean.defaultKeyStore(), ADD_KEY_STORE_MENU_STRING)) {
                    this._bean.setKeyStore(newKeyStore);
                    KeyStoreTreeNode newNode = new KeyStoreTreeNode(this, newKeyStore);
                    this.insertNode(newNode);
                    this._addKeyStoreMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SIGNATURE_KEY_MENU_STRING)) {
                KeyConfigType newSignatureKey;
                if (this._bean.getSignatureKey() == null && this.showAddDialog(newSignatureKey = this._bean.defaultSignatureKey(), ADD_SIGNATURE_KEY_MENU_STRING)) {
                    this._bean.setSignatureKey(newSignatureKey);
                    KeyConfigTreeNode newNode = new KeyConfigTreeNode(this, newSignatureKey, SIGNATURE_KEY_TEXT);
                    this.insertNode(newNode);
                    this._addSignatureKeyMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_ENCRYPTION_KEY_MENU_STRING)) {
                KeyConfigType newEncryptionKey;
                if (this._bean.getEncryptionKey() == null && this.showAddDialog(newEncryptionKey = this._bean.defaultEncryptionKey(), ADD_ENCRYPTION_KEY_MENU_STRING)) {
                    this._bean.setEncryptionKey(newEncryptionKey);
                    KeyConfigTreeNode newNode = new KeyConfigTreeNode(this, newEncryptionKey, ENCRYPTION_KEY_TEXT);
                    this.insertNode(newNode);
                    this._addEncryptionKeyMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_NONCE_CONFIG_MENU_STRING)) {
                NonceConfigType newNonceConfig;
                if (this._bean.getNonceConfig() == null && this.showAddDialog(newNonceConfig = this._bean.defaultNonceConfig(), ADD_NONCE_CONFIG_MENU_STRING)) {
                    this._bean.setNonceConfig(newNonceConfig);
                    NonceConfigTreeNode newNode = new NonceConfigTreeNode(this, newNonceConfig);
                    this.insertNode(newNode);
                    this._addNonceConfigMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_INBOUND_MENU_STRING)) {
                if (this._bean.getInbound() == null) {
                    this._bean.addInbound();
                    InboundTreeNode newNode = new InboundTreeNode(this, this._bean.getInbound());
                    this.insertNode(newNode);
                    this._addInboundMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_OUTBOUND_MENU_STRING)) {
                if (this._bean.getOutbound() == null) {
                    this._bean.addOutbound();
                    OutboundTreeNode newNode = new OutboundTreeNode(this, this._bean.getOutbound());
                    this.insertNode(newNode);
                    this._addOutboundMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_SECURITY_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof KeyStoreTreeNode) {
            this._bean.removeKeyStore();
            this.removeNode(node);
            this._addKeyStoreMenuItem.setEnabled(true);
        } else if (node instanceof KeyConfigTreeNode) {
            KeyConfigTreeNode keyConfigTreeNode = (KeyConfigTreeNode)node;
            if (SIGNATURE_KEY_TEXT.equals(keyConfigTreeNode.getDisplayText())) {
                this._bean.removeSignatureKey();
                this.removeNode(node);
                this._addSignatureKeyMenuItem.setEnabled(true);
            } else if (ENCRYPTION_KEY_TEXT.equals(keyConfigTreeNode.getDisplayText())) {
                this._bean.removeEncryptionKey();
                this.removeNode(node);
                this._addEncryptionKeyMenuItem.setEnabled(true);
            }
        } else if (node instanceof NonceConfigTreeNode) {
            this._bean.removeNonceConfig();
            this.removeNode(node);
            this._addNonceConfigMenuItem.setEnabled(true);
        } else if (node instanceof InboundTreeNode) {
            this._bean.removeInbound();
            this.removeNode(node);
            this._addInboundMenuItem.setEnabled(true);
        } else if (node instanceof OutboundTreeNode) {
            this._bean.removeOutbound();
            this.removeNode(node);
            this._addOutboundMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        }
    }
}

