/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SamlAuthorityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SamlAuthorityTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SamlTokenConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SubjectConfirmationMethodConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SubjectConfirmationMethodTreeNode;

public class SamlTokenTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SamlTokenConfigType _bean;
    private static final String ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING = "Add Subject Confirmation Method";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String ADD_SAML_AUTHORITY_MENU_STRING = "Add Saml Authority";
    private static final String REMOVE_SAML_TOKEN_CONFIG_MENU_STRING = "Remove Saml Token Config";
    private JMenuItem _addSubjectConfirmationMethodMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _addSamlAuthorityMenuItem;
    private JMenuItem _removeSamlTokenConfigMenuItem;

    public SamlTokenTreeNode(ConfigTreeNode rootNode, SamlTokenConfigType SamlTokenConfig) {
        super(SamlTokenConfig);
        this.setRootNode(rootNode);
        this._bean = SamlTokenConfig;
        this._addSubjectConfirmationMethodMenuItem = new JMenuItem(ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING);
        this._addSubjectConfirmationMethodMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSubjectConfirmationMethodMenuItem.setFont(SamlTokenTreeNode.getFont());
        this._addSubjectConfirmationMethodMenuItem.addActionListener(this);
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(SamlTokenTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._addSamlAuthorityMenuItem = new JMenuItem(ADD_SAML_AUTHORITY_MENU_STRING);
        this._addSamlAuthorityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSamlAuthorityMenuItem.setFont(SamlTokenTreeNode.getFont());
        this._addSamlAuthorityMenuItem.addActionListener(this);
        this._removeSamlTokenConfigMenuItem = new JMenuItem(REMOVE_SAML_TOKEN_CONFIG_MENU_STRING);
        this._removeSamlTokenConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSamlTokenConfigMenuItem.setFont(SamlTokenTreeNode.getFont());
        this._removeSamlTokenConfigMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._addSubjectConfirmationMethodMenuItem);
        this._popup.add(this._addSamlAuthorityMenuItem);
        this._popup.add(this._removeSamlTokenConfigMenuItem);
    }

    public String viewHeaderString() {
        return "Saml Token Config";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        SamlAuthorityConfigType samlAuthority;
        PropertyConfigBean[] properties;
        SubjectConfirmationMethodConfigType subjectConfirmationMethod = this._bean.getSubjectConfirmationMethod();
        if (subjectConfirmationMethod != null) {
            SubjectConfirmationMethodTreeNode subjectConfirmationMethodTreeNode = new SubjectConfirmationMethodTreeNode(this.getRootNode(), subjectConfirmationMethod);
            this.addChild(subjectConfirmationMethodTreeNode);
        }
        if ((properties = this._bean.getProperties()) != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
        if ((samlAuthority = this._bean.getSamlAuthority()) != null) {
            SamlAuthorityTreeNode samlAuthorityTreeNode = new SamlAuthorityTreeNode(this.getRootNode(), samlAuthority);
            this.addChild(samlAuthorityTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING)) {
                SubjectConfirmationMethodConfigType newSubjectConfirmationMethod = this._bean.defaultSubjectConfirmationMethod();
                if (this.showAddDialog(newSubjectConfirmationMethod, ADD_SUBJECT_CONFIRMATION_METHOD_MENU_STRING)) {
                    this._bean.setSubjectConfirmationMethod(newSubjectConfirmationMethod);
                    SubjectConfirmationMethodTreeNode newNode = new SubjectConfirmationMethodTreeNode(this, newSubjectConfirmationMethod);
                    this.insertNode(newNode);
                    this._addSubjectConfirmationMethodMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                    PropertyTreeNode newNode = new PropertyTreeNode(this, newProperty);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(ADD_SAML_AUTHORITY_MENU_STRING)) {
                SamlAuthorityConfigType newSamlAuthority = this._bean.defaultSamlAuthority();
                if (this.showAddDialog(newSamlAuthority, ADD_SAML_AUTHORITY_MENU_STRING)) {
                    this._bean.setSamlAuthority(newSamlAuthority);
                    SamlAuthorityTreeNode newNode = new SamlAuthorityTreeNode(this, newSamlAuthority);
                    this.insertNode(newNode);
                    this._addSamlAuthorityMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_SAML_TOKEN_CONFIG_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SubjectConfirmationMethodTreeNode) {
            this._bean.removeSubjectConfirmationMethod();
            this.removeNode(node);
            this._addSubjectConfirmationMethodMenuItem.setEnabled(true);
        } else if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        } else if (node instanceof SamlAuthorityTreeNode) {
            this._bean.removeSamlAuthority();
            this.removeNode(node);
            this._addSamlAuthorityMenuItem.setEnabled(true);
        }
    }
}

