/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ClientRepositoryTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClientRepositoryType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ReliabilityClientType;

public class ReliabilityClientTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ReliabilityClientType _bean;
    private static final String ADD_REPOSITORY_MENU_STRING = "Add Repository";
    private static final String REMOVE_RELIABILITY_MENU_STRING = "Remove Reliability";
    private JMenuItem _addRepositoryMenuItem;
    private JMenuItem _removeReliabilityMenuItem;

    public ReliabilityClientTreeNode(ConfigTreeNode rootNode, ReliabilityClientType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addRepositoryMenuItem = new JMenuItem(ADD_REPOSITORY_MENU_STRING);
        this._addRepositoryMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addRepositoryMenuItem.setFont(ReliabilityClientTreeNode.getFont());
        this._addRepositoryMenuItem.addActionListener(this);
        if (this._bean.getRepository() != null) {
            this._addRepositoryMenuItem.setEnabled(false);
        }
        this._removeReliabilityMenuItem = new JMenuItem(REMOVE_RELIABILITY_MENU_STRING);
        this._removeReliabilityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeReliabilityMenuItem.setFont(ReliabilityClientTreeNode.getFont());
        this._removeReliabilityMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addRepositoryMenuItem);
        this._popup.add(this._removeReliabilityMenuItem);
    }

    public String viewHeaderString() {
        return "Reliability";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ClientRepositoryType repository = this._bean.getRepository();
            if (repository != null) {
                ClientRepositoryTreeNode clientRepositoryTreeNode = new ClientRepositoryTreeNode(this.getRootNode(), repository);
                this.addChild(clientRepositoryTreeNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_REPOSITORY_MENU_STRING)) {
                ClientRepositoryType newRepository;
                if (this._bean.getRepository() == null && this.showAddDialog(newRepository = this._bean.defaultRepository(), ADD_REPOSITORY_MENU_STRING)) {
                    this._bean.setRepository(newRepository);
                    ClientRepositoryTreeNode newNode = new ClientRepositoryTreeNode(this, newRepository);
                    this.insertNode(newNode);
                    this._addRepositoryMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_RELIABILITY_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ClientRepositoryTreeNode) {
            this._bean.removeRepository();
            this.removeNode(node);
            this._addRepositoryMenuItem.setEnabled(true);
        }
    }
}

