/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyConfigType
extends ConfigBeanNode {
    protected String _propertyString = null;
    protected String _url = null;

    public PropertyConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public PropertyConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setPropertyString(String propertyString) throws ConfigurationException {
        String oldValue = this._propertyString;
        this._propertyString = propertyString;
        this.firePropertyChange("propertyString", oldValue, this._propertyString);
    }

    public String getPropertyString() {
        return this._propertyString;
    }

    public String defaultPropertyString() {
        return "";
    }

    public void setUrl(String url) throws ConfigurationException {
        String oldValue = this._url;
        this._url = url;
        this.firePropertyChange("url", oldValue, this._url);
    }

    public String getUrl() {
        return this._url;
    }

    public String defaultUrl() {
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "property-config");
        XMLUtils.writeTagAttributeEnd(out, indentation, "property-config");
        if (this._propertyString != null && this._propertyString.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t\t", "property-string", this._propertyString);
        }
        if (this._url != null && this._url.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t\t", "url", this._url);
        }
        XMLUtils.writeTagEnd(out, indentation, "property-config");
    }

    private void init() throws ConfigurationException {
        this.setXpath("property-config");
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("property-string")) {
                    this.setPropertyString(XMLUtils.getValue(node));
                    continue;
                }
                if (!name.equals("url")) continue;
                this.setUrl(XMLUtils.getValue(node));
            }
        }
    }
}

