/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.CacheSynchronizationTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.CacheSynchronizationType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PmDefaultMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PmDefaultMappingType;
import oracle.oc4j.admin.deploy.spi.xml.PmPropertiesType;

public class PmPropertiesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PmPropertiesType _bean;
    private static final String ADD_CACHE_SYNCHRONIZATION_MENU_STRING = "Add Cache Synchronization";
    private static final String ADD_DEFAULT_MAPPING_MENU_STRING = "Add Default Mapping";
    private static final String REMOVE_PM_PROPERTIES_MENU_STRING = "Remove Pm Properties";
    private JMenuItem _addCacheSynchronizationMenuItem;
    private JMenuItem _addDefaultMappingMenuItem;
    private JMenuItem _removePmPropertiesMenuItem;

    public PmPropertiesTreeNode(ConfigTreeNode rootNode, PmPropertiesType pmProperties) {
        super(pmProperties);
        this.setRootNode(rootNode);
        this._bean = pmProperties;
        this._addCacheSynchronizationMenuItem = new JMenuItem(ADD_CACHE_SYNCHRONIZATION_MENU_STRING);
        this._addCacheSynchronizationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addCacheSynchronizationMenuItem.setFont(PmPropertiesTreeNode.getFont());
        this._addCacheSynchronizationMenuItem.addActionListener(this);
        if (this._bean.getCacheSynchronization() != null) {
            this._addCacheSynchronizationMenuItem.setEnabled(false);
        }
        this._addDefaultMappingMenuItem = new JMenuItem(ADD_DEFAULT_MAPPING_MENU_STRING);
        this._addDefaultMappingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addDefaultMappingMenuItem.setFont(PmPropertiesTreeNode.getFont());
        this._addDefaultMappingMenuItem.addActionListener(this);
        if (this._bean.getDefaultMapping() != null) {
            this._addDefaultMappingMenuItem.setEnabled(false);
        }
        this._removePmPropertiesMenuItem = new JMenuItem(REMOVE_PM_PROPERTIES_MENU_STRING);
        this._removePmPropertiesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removePmPropertiesMenuItem.setFont(PmPropertiesTreeNode.getFont());
        this._removePmPropertiesMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addCacheSynchronizationMenuItem);
        this._popup.add(this._addDefaultMappingMenuItem);
        this._popup.add(this._removePmPropertiesMenuItem);
    }

    public String viewHeaderString() {
        return "Pm Properties";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PmDefaultMappingType defaultMapping;
        CacheSynchronizationType cacheSynchronization = this._bean.getCacheSynchronization();
        if (cacheSynchronization != null) {
            CacheSynchronizationTreeNode cacheSynchronizationTreeNode = new CacheSynchronizationTreeNode(this.getRootNode(), cacheSynchronization);
            this.addChild(cacheSynchronizationTreeNode);
        }
        if ((defaultMapping = this._bean.getDefaultMapping()) != null) {
            PmDefaultMappingTreeNode pmDefaultMappingTreeNode = new PmDefaultMappingTreeNode(this.getRootNode(), defaultMapping);
            this.addChild(pmDefaultMappingTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_CACHE_SYNCHRONIZATION_MENU_STRING)) {
                CacheSynchronizationType newCacheSynchronization = this._bean.defaultCacheSynchronization();
                if (this.showAddDialog(newCacheSynchronization, ADD_CACHE_SYNCHRONIZATION_MENU_STRING)) {
                    this._bean.setCacheSynchronization(newCacheSynchronization);
                    CacheSynchronizationTreeNode newNode = new CacheSynchronizationTreeNode(this, newCacheSynchronization);
                    this.insertNode(newNode);
                    this._addCacheSynchronizationMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_DEFAULT_MAPPING_MENU_STRING)) {
                PmDefaultMappingType newDefaultMapping = this._bean.defaultDefaultMapping();
                if (this.showAddDialog(newDefaultMapping, ADD_DEFAULT_MAPPING_MENU_STRING)) {
                    this._bean.setDefaultMapping(newDefaultMapping);
                    PmDefaultMappingTreeNode newNode = new PmDefaultMappingTreeNode(this, newDefaultMapping);
                    this.insertNode(newNode);
                    this._addDefaultMappingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PM_PROPERTIES_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof CacheSynchronizationTreeNode) {
            this._bean.removeCacheSynchronization();
            this.removeNode(node);
            this._addCacheSynchronizationMenuItem.setEnabled(true);
        } else if (node instanceof PmDefaultMappingTreeNode) {
            this._bean.removeDefaultMapping();
            this.removeNode(node);
            this._addDefaultMappingMenuItem.setEnabled(true);
        }
    }
}

