/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PersistenceManagerType;
import oracle.oc4j.admin.deploy.spi.xml.PmPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PmPropertiesType;

public class PersistenceManagerTreeNode
extends ConfigTreeNode
implements ActionListener {
    private PersistenceManagerType _bean;
    private static final String ADD_PM_PROPERTIES_MENU_STRING = "Add Pm Properties";
    private static final String REMOVE_PERSISTENCE_MANAGER_MENU_STRING = "Remove Persistence Manager";
    private JMenuItem _addPmPropertiesMenuItem;
    private JMenuItem _removePersistenceManagerMenuItem;

    public PersistenceManagerTreeNode(ConfigTreeNode rootNode, PersistenceManagerType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addPmPropertiesMenuItem = new JMenuItem(ADD_PM_PROPERTIES_MENU_STRING);
        this._addPmPropertiesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPmPropertiesMenuItem.setFont(PersistenceManagerTreeNode.getFont());
        this._addPmPropertiesMenuItem.addActionListener(this);
        if (this._bean.getPmProperties() != null) {
            this._addPmPropertiesMenuItem.setEnabled(false);
        }
        this._removePersistenceManagerMenuItem = new JMenuItem(REMOVE_PERSISTENCE_MANAGER_MENU_STRING);
        this._removePersistenceManagerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removePersistenceManagerMenuItem.setFont(PersistenceManagerTreeNode.getFont());
        this._removePersistenceManagerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPmPropertiesMenuItem);
        this._popup.add(this._removePersistenceManagerMenuItem);
    }

    public String viewHeaderString() {
        return "Persistence Manager";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        PmPropertiesType pmProperties = this._bean.getPmProperties();
        if (pmProperties != null) {
            PmPropertiesTreeNode pmPropertiesTreeNode = new PmPropertiesTreeNode(this.getRootNode(), pmProperties);
            this.addChild(pmPropertiesTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_PM_PROPERTIES_MENU_STRING)) {
                PmPropertiesType newPmProperties = new PmPropertiesType(this._bean);
                if (this.showAddDialog(newPmProperties, ADD_PM_PROPERTIES_MENU_STRING)) {
                    this._bean.setPmProperties(newPmProperties);
                    PmPropertiesTreeNode newNode = new PmPropertiesTreeNode(this, newPmProperties);
                    this.insertNode(newNode);
                    this._addPmPropertiesMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_PERSISTENCE_MANAGER_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PmPropertiesTreeNode) {
            this._bean.removePmProperties();
            this.removeNode(node);
            this._addPmPropertiesMenuItem.setEnabled(true);
        }
    }
}

