/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.GroupsType;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceAccessType;
import oracle.oc4j.admin.deploy.spi.xml.NamespaceResourceType;
import oracle.oc4j.admin.deploy.spi.xml.UsersTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.UsersType;

public class NamespaceResourceTreeNode
extends ConfigTreeNode
implements ActionListener {
    private NamespaceResourceType _bean;
    private static final String REMOVE_NAMESPACE_RESOURCE_MENU_STRING = "Remove Namespace Resource";
    private JMenuItem _removeNamespaceResourceMenuItem;

    public NamespaceResourceTreeNode(ConfigTreeNode rootNode, NamespaceResourceType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._removeNamespaceResourceMenuItem = new JMenuItem(REMOVE_NAMESPACE_RESOURCE_MENU_STRING);
        this._removeNamespaceResourceMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeNamespaceResourceMenuItem.setFont(NamespaceResourceTreeNode.getFont());
        this._removeNamespaceResourceMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeNamespaceResourceMenuItem);
    }

    public String viewHeaderString() {
        return "Namespace Resource";
    }

    public String toString() {
        NamespaceResourceType resource = ((NamespaceAccessType)this._bean.getConfigParent()).getNamespaceReadAccess();
        if (resource != null && resource.equals(this._bean)) {
            return "Read Access";
        }
        resource = ((NamespaceAccessType)this._bean.getConfigParent()).getNamespaceWriteAccess();
        if (resource != null && resource.equals(this._bean)) {
            return "Write Access";
        }
        return "";
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = NamespaceResourceType.class.getMethod("writeGroupsXML", PrintWriter.class, String.class);
            GroupsTreeNode groupsTreeNode = new GroupsTreeNode(this.getRootNode(), new GroupsType(this._bean, xmlMethod));
            this.addChild(groupsTreeNode);
            xmlMethod = NamespaceResourceType.class.getMethod("writeUsersXML", PrintWriter.class, String.class);
            UsersTreeNode usersTreeNode = new UsersTreeNode(this.getRootNode(), new UsersType(this._bean, xmlMethod));
            this.addChild(usersTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_NAMESPACE_RESOURCE_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

