/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.KeyTransportMethodConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyTransportMethodsConfigType
extends ConfigBeanNode {
    KeyTransportMethodConfigType[] _keyTransportMethods = null;

    public KeyTransportMethodsConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public KeyTransportMethodsConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setKeyTransportMethods(KeyTransportMethodConfigType[] keyTransportMethods) throws ConfigurationException {
        KeyTransportMethodConfigType[] oldValue = this._keyTransportMethods;
        this._keyTransportMethods = keyTransportMethods;
        this.firePropertyChange("keyTransportMethods", oldValue, this._keyTransportMethods);
    }

    public KeyTransportMethodConfigType[] getKeyTransportMethods() {
        return this._keyTransportMethods;
    }

    public KeyTransportMethodConfigType[] defaultKeyTransportMethods() {
        return new KeyTransportMethodConfigType[0];
    }

    public void addKeyTransportMethods() throws ConfigurationException {
        if (this._keyTransportMethods != null) {
            return;
        }
        KeyTransportMethodConfigType[] keyTransportMethods = new KeyTransportMethodConfigType[]{new KeyTransportMethodConfigType(this)};
        this.setKeyTransportMethods(keyTransportMethods);
    }

    public void removeKeyTransportMethods() throws ConfigurationException {
        if (this._keyTransportMethods == null) {
            return;
        }
        this.setKeyTransportMethods(null);
    }

    public void addKeyTransportMethod(KeyTransportMethodConfigType keyTransportMethod) throws ConfigurationException {
        keyTransportMethod.setParent(this);
        int existingKeyTransportMethodsCnt = 0;
        if (this._keyTransportMethods != null) {
            existingKeyTransportMethodsCnt = this._keyTransportMethods.length;
        }
        KeyTransportMethodConfigType[] newKeyTransportMethods = new KeyTransportMethodConfigType[existingKeyTransportMethodsCnt + 1];
        for (int n = 0; n < existingKeyTransportMethodsCnt; ++n) {
            newKeyTransportMethods[n] = this._keyTransportMethods[n];
        }
        newKeyTransportMethods[existingKeyTransportMethodsCnt] = keyTransportMethod;
        KeyTransportMethodConfigType[] oldValue = this._keyTransportMethods;
        this._keyTransportMethods = newKeyTransportMethods;
        this.firePropertyChange("keyTransportMethods", oldValue, this._keyTransportMethods);
    }

    public void removeKeyTransportMethod(KeyTransportMethodConfigType keyTransportMethod) throws ConfigurationException {
        int existingKeyTransportMethodsCnt = 0;
        if (this._keyTransportMethods != null) {
            existingKeyTransportMethodsCnt = this._keyTransportMethods.length;
        }
        KeyTransportMethodConfigType[] newKeyTransportMethods = new KeyTransportMethodConfigType[existingKeyTransportMethodsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingKeyTransportMethodsCnt; ++n) {
            if (keyTransportMethod.equals(this._keyTransportMethods[n])) continue;
            newKeyTransportMethods[newIndex++] = this._keyTransportMethods[n];
        }
        if (newKeyTransportMethods.length == 0) {
            newKeyTransportMethods = null;
        }
        KeyTransportMethodConfigType[] oldValue = this._keyTransportMethods;
        this._keyTransportMethods = newKeyTransportMethods;
        this.firePropertyChange("keyTransportMethods", oldValue, this._keyTransportMethods);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "keytransport-methods");
        XMLUtils.writeTagAttributeEnd(out, indentation, "keytransport-methods");
        KeyTransportMethodsConfigType.writeXML(out, indentation + "\t", this._keyTransportMethods);
        XMLUtils.writeTagEnd(out, indentation, "keytransport-methods");
    }

    private void init() throws ConfigurationException {
        this.setXpath("keytransport-methods");
        Vector<KeyTransportMethodConfigType> keyTransportMethods = new Vector<KeyTransportMethodConfigType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("keytransport-method")) continue;
                KeyTransportMethodConfigType configBean = new KeyTransportMethodConfigType(this, node);
                keyTransportMethods.add(configBean);
            }
        }
        if (keyTransportMethods.size() > 0) {
            this.setKeyTransportMethods(keyTransportMethods.toArray(new KeyTransportMethodConfigType[0]));
        }
    }
}

