/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpAccessType
extends ConfigBeanNode {
    StringType _mode = null;
    StringType _oldMode = null;
    String _ip = null;
    String _netmask = null;

    public IpAccessType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public IpAccessType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setIp(String ip) throws ConfigurationException {
        String oldValue = this._ip;
        this._ip = ip;
        this.firePropertyChange("ip", oldValue, this._ip);
    }

    public String getIp() {
        return this._ip;
    }

    public String defaultIp() {
        return "";
    }

    public void setMode(StringType mode) throws ConfigurationException {
        this._mode = mode;
        this.firePropertyChange("mode", this._oldMode, this._mode);
        if (this._mode != null) {
            if (this._oldMode == null) {
                this._oldMode = this.defaultMode();
            }
            this._oldMode.setValue(this._mode.getValue());
        } else {
            this._oldMode = null;
        }
    }

    public StringType getMode() {
        return this._mode;
    }

    public StringType defaultMode() {
        String[] tags = new String[]{"deny", "allow"};
        return new StringType(this, tags, "allow");
    }

    public void setNetmask(String netmask) throws ConfigurationException {
        String oldValue = this._netmask;
        this._netmask = netmask;
        this.firePropertyChange("netmask", oldValue, this._netmask);
    }

    public String getNetmask() {
        return this._netmask;
    }

    public String defaultNetmask() {
        return "";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "ip-access");
        XMLUtils.writeAttribute(out, indentation, "ip", this._ip);
        XMLUtils.writeAttribute(out, indentation, "mode", this._mode);
        XMLUtils.writeAttribute(out, indentation, "netmask", this._netmask);
        XMLUtils.writeTagAttributeEnd(out, indentation, "ip-access");
        XMLUtils.writeTagEnd(out, indentation, "ip-access");
    }

    public static void writeXML(PrintWriter out, String indentation, IpAccessType[] ipAccess) throws ExtendedRuntimeException {
        if (ipAccess == null) {
            return;
        }
        for (int n = 0; n < ipAccess.length; ++n) {
            ipAccess[n].writeXML(out, indentation);
        }
    }

    private void init() throws ConfigurationException {
        this.setXpath("ip-access");
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "ip");
            if (val != null && !val.trim().equals("")) {
                this.setIp(val);
            }
            if ((val = XMLUtils.getAttribute(node, "mode")) != null && !val.trim().equals("")) {
                StringType mode = this.defaultMode();
                mode.setValue(val);
                this.setMode(mode);
            }
            if ((val = XMLUtils.getAttribute(node, "netmask")) != null && !val.trim().equals("")) {
                this.setNetmask(val);
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
            }
        }
    }
}

