/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.AsContextTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.AsContextType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.IorSecurityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.SasContextTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SasContextType;
import oracle.oc4j.admin.deploy.spi.xml.TransportConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TransportConfigType;

public class IorSecurityConfigTreeNode
extends ConfigTreeNode
implements ActionListener {
    private IorSecurityConfigType _bean;
    private static final String ADD_TRANSPORT_CONFIG_MENU_STRING = "Add Transport Config";
    private static final String ADD_AS_CONTEXT_MENU_STRING = "Add As Context";
    private static final String ADD_SAS_CONTEXT_MENU_STRING = "Add Sas Context";
    private static final String REMOVE_IOR_SECURITY_CONFIG_MENU_STRING = "Remove Ior Security Config";
    private JMenuItem _addTransportConfigMenuItem;
    private JMenuItem _addAsContextMenuItem;
    private JMenuItem _addSasContextMenuItem;
    private JMenuItem _removeIorSecurityConfigMenuItem;

    public IorSecurityConfigTreeNode(ConfigTreeNode rootNode, IorSecurityConfigType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addTransportConfigMenuItem = new JMenuItem(ADD_TRANSPORT_CONFIG_MENU_STRING);
        this._addTransportConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTransportConfigMenuItem.setFont(IorSecurityConfigTreeNode.getFont());
        this._addTransportConfigMenuItem.addActionListener(this);
        if (this._bean.getTransportConfig() != null) {
            this._addTransportConfigMenuItem.setEnabled(false);
        }
        this._addAsContextMenuItem = new JMenuItem(ADD_AS_CONTEXT_MENU_STRING);
        this._addAsContextMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addAsContextMenuItem.setFont(IorSecurityConfigTreeNode.getFont());
        this._addAsContextMenuItem.addActionListener(this);
        if (this._bean.getAsContext() != null) {
            this._addAsContextMenuItem.setEnabled(false);
        }
        this._addSasContextMenuItem = new JMenuItem(ADD_SAS_CONTEXT_MENU_STRING);
        this._addSasContextMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSasContextMenuItem.setFont(IorSecurityConfigTreeNode.getFont());
        this._addSasContextMenuItem.addActionListener(this);
        if (this._bean.getSasContext() != null) {
            this._addSasContextMenuItem.setEnabled(false);
        }
        this._removeIorSecurityConfigMenuItem = new JMenuItem(REMOVE_IOR_SECURITY_CONFIG_MENU_STRING);
        this._removeIorSecurityConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeIorSecurityConfigMenuItem.setFont(IorSecurityConfigTreeNode.getFont());
        this._removeIorSecurityConfigMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addTransportConfigMenuItem);
        this._popup.add(this._addAsContextMenuItem);
        this._popup.add(this._addSasContextMenuItem);
        this._popup.add(this._removeIorSecurityConfigMenuItem);
    }

    public String viewHeaderString() {
        return "Ior Security Config";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        SasContextType sasContext;
        AsContextType asContext;
        TransportConfigType transportConfig = this._bean.getTransportConfig();
        if (transportConfig != null) {
            TransportConfigTreeNode transportConfigTreeNode = new TransportConfigTreeNode(this.getRootNode(), transportConfig);
            this.addChild(transportConfigTreeNode);
        }
        if ((asContext = this._bean.getAsContext()) != null) {
            AsContextTreeNode asContextTreeNode = new AsContextTreeNode(this.getRootNode(), asContext);
            this.addChild(asContextTreeNode);
        }
        if ((sasContext = this._bean.getSasContext()) != null) {
            SasContextTreeNode sasContextTreeNode = new SasContextTreeNode(this.getRootNode(), sasContext);
            this.addChild(sasContextTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_TRANSPORT_CONFIG_MENU_STRING)) {
                TransportConfigType newTransportConfig = new TransportConfigType(this._bean);
                if (this.showAddDialog(newTransportConfig, ADD_TRANSPORT_CONFIG_MENU_STRING)) {
                    this._bean.setTransportConfig(newTransportConfig);
                    TransportConfigTreeNode newNode = new TransportConfigTreeNode(this, newTransportConfig);
                    this.insertNode(newNode);
                    this._addTransportConfigMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_AS_CONTEXT_MENU_STRING)) {
                AsContextType newAsContext = new AsContextType(this._bean);
                if (this.showAddDialog(newAsContext, ADD_AS_CONTEXT_MENU_STRING)) {
                    this._bean.setAsContext(newAsContext);
                    AsContextTreeNode newNode = new AsContextTreeNode(this, newAsContext);
                    this.insertNode(newNode);
                    this._addAsContextMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SAS_CONTEXT_MENU_STRING)) {
                SasContextType newSasContext = new SasContextType(this._bean);
                if (this.showAddDialog(newSasContext, ADD_SAS_CONTEXT_MENU_STRING)) {
                    this._bean.setSasContext(newSasContext);
                    SasContextTreeNode newNode = new SasContextTreeNode(this, newSasContext);
                    this.insertNode(newNode);
                    this._addSasContextMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_IOR_SECURITY_CONFIG_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof TransportConfigTreeNode) {
            this._bean.removeTransportConfig();
            this.removeNode(node);
            this._addTransportConfigMenuItem.setEnabled(true);
        } else if (node instanceof AsContextTreeNode) {
            this._bean.removeAsContext();
            this.removeNode(node);
            this._addAsContextMenuItem.setEnabled(true);
        } else if (node instanceof SasContextTreeNode) {
            this._bean.removeSasContext();
            this.removeNode(node);
            this._addSasContextMenuItem.setEnabled(true);
        }
    }
}

