/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.CommitOptionTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.CommitOptionType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.EntityDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.IorSecurityConfigsTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class EntityMappingsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private EntityDeploymentConfigBean _bean;
    private static final String ADD_COMMIT_OPTION_MENU_STRING = "Add Commit Option";
    private JMenuItem _addCommitOptionMenuItem;

    public EntityMappingsTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (EntityDeploymentConfigBean)bean;
        this._addCommitOptionMenuItem = new JMenuItem(ADD_COMMIT_OPTION_MENU_STRING);
        this._addCommitOptionMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addCommitOptionMenuItem.setFont(EntityMappingsTreeNode.getFont());
        this._addCommitOptionMenuItem.addActionListener(this);
        if (this._bean.getCommitOption() != null) {
            this._addCommitOptionMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addCommitOptionMenuItem);
    }

    public String viewHeaderString() {
        return "Entity Bean Mappings";
    }

    public String toString() {
        return this._bean.getName();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = EntityDeploymentConfigBean.class.getMethod("writeIorSecurityConfigsXML", PrintWriter.class, String.class);
            IorSecurityConfigsTreeNode iorSecurityConfigsTreeNode = new IorSecurityConfigsTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(iorSecurityConfigsTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        CommitOptionType commitOption = this._bean.getCommitOption();
        if (commitOption != null) {
            CommitOptionTreeNode commitOptionTreeNode = new CommitOptionTreeNode(this, commitOption);
            this.addChild(commitOptionTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            CommitOptionType newCommitOption;
            if (event.getActionCommand().equals(ADD_COMMIT_OPTION_MENU_STRING) && this.showAddDialog(newCommitOption = this._bean.defaultCommitOption(), ADD_COMMIT_OPTION_MENU_STRING)) {
                this._bean.setCommitOption(newCommitOption);
                CommitOptionTreeNode newNode = new CommitOptionTreeNode(this, newCommitOption);
                this.insertNode(newNode);
                this._addCommitOptionMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof CommitOptionTreeNode) {
            this._bean.removeCommitOption();
            this.removeNode(node);
            this._addCommitOptionMenuItem.setEnabled(true);
        }
    }
}

