/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionPoolingType
extends ConfigBeanNode {
    String _use = null;
    String _useConnectionPool = null;
    PropertyConfigBean[] _properties = null;

    public ConnectionPoolingType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public ConnectionPoolingType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setUse(String use) throws ConfigurationException {
        String oldValue = this._use;
        this._use = use;
        this.firePropertyChange("use", oldValue, this._use);
    }

    public String getUse() {
        return this._use;
    }

    public String defaultUse() {
        return "";
    }

    public void setUseConnectionPool(String useConnectionPool) throws ConfigurationException {
        String oldValue = this._useConnectionPool;
        this._useConnectionPool = useConnectionPool;
        this.firePropertyChange("useConnectionPool", oldValue, this._useConnectionPool);
    }

    public String getUseConnectionPool() {
        return this._useConnectionPool;
    }

    public String defaultUseConnectionPool() {
        return "";
    }

    public void setProperties(PropertyConfigBean[] properties) {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        return properties;
    }

    public void addProperties() {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "connection-pooling");
        XMLUtils.writeAttribute(out, indentation, "use", this._use);
        XMLUtils.writeTagAttributeEnd(out, indentation, "connection-pooling");
        if (this._useConnectionPool != null && this._useConnectionPool.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "use-connection-pool", this._useConnectionPool);
        }
        if (this._properties != null && this._properties.length > 0) {
            ConnectionPoolingType.writeXML(out, indentation + "\t", this._properties);
        }
        XMLUtils.writeTagEnd(out, indentation, "connection-pooling");
    }

    private void init() {
        this.setXpath("connection-pooling");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "use");
            if (val != null && !val.trim().equals("")) {
                this._use = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("property")) {
                    PropertyConfigBean property = new PropertyConfigBean(this, node);
                    properties.add(property);
                    continue;
                }
                if (!name.equals("use-connection-pool")) continue;
                this._useConnectionPool = XMLUtils.getValue(node);
            }
        }
        this._properties = properties.toArray(new PropertyConfigBean[0]);
    }
}

