/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.DeplConfiguration;
import oracle.oc4j.admin.deploy.spi.DeplManager;
import oracle.oc4j.admin.deploy.spi.Oc4jDeploymentManager;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.AppType;
import oracle.oc4j.admin.deploy.spi.xml.ApplicationConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.BooleanType;
import oracle.oc4j.admin.deploy.spi.xml.CarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanXpathInfo;
import oracle.oc4j.admin.deploy.spi.xml.EarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.EjbDepXml;
import oracle.oc4j.admin.deploy.spi.xml.JaznConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.RarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import oracle.oc4j.admin.deploy.spi.xml.WSDepXml;
import oracle.oc4j.admin.deploy.spi.xml.WarDepXml;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteBindingType;
import oracle.oc4j.admin.deploy.spi.xml.WebSiteType;
import oracle.oc4j.admin.management.shared.Group;
import oracle.oc4j.admin.management.shared.User;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ConfigBeanRootNode
extends ConfigBeanNode
implements DConfigBeanRoot {
    static XMLSchema _earSchema = null;
    static XMLSchema _warSchema = null;
    static XMLSchema _ejbSchema = null;
    static XMLSchema _carSchema = null;
    static XMLSchema _rarSchema = null;
    static XMLSchema _wsSchema = null;
    protected String _applicationId = null;
    protected WebSiteType _webSiteBinding = null;
    protected AppType _parentApp = null;
    protected Target _target = null;
    protected DeplManager _deploymentManager = null;
    protected boolean _initFromDeployment = false;
    protected String _moduleId = null;
    protected ConfigBeanRootNode _rootParent = null;
    protected boolean _dontSaveConfiguration = false;
    protected ConfigBeanNode _module = null;
    protected BooleanType _enableIIOP = null;
    private Hashtable _otherConfigBeans = null;
    private DeployableObject _deployableObject = null;
    private String _language = null;
    private Hashtable _jaznRealms = null;
    private String _defaultRealmName = null;
    private Hashtable _webSiteBindings = new Hashtable();
    private Hashtable _webSiteBindingNames = null;
    private BooleanType _removeArchive = null;
    private BooleanType _failureRecovery = null;

    public ConfigBeanRootNode(String moduleId, DDBean stdBean, DeplManager mgr, ConfigBeanRootNode rootParent) {
        this(moduleId, stdBean, null, mgr, rootParent);
    }

    public ConfigBeanRootNode(String moduleId, DDBean stdBean, Node node, DeplManager mgr, ConfigBeanRootNode rootParent) {
        super(stdBean, node);
        Target target;
        this._moduleId = moduleId;
        this._deploymentManager = mgr;
        this._rootParent = rootParent;
        if (this._rootParent == null && this._deploymentManager instanceof Oc4jDeploymentManager && this._deploymentManager.isConnected() && (target = ((Oc4jDeploymentManager)this._deploymentManager).getValidationTarget()) != null) {
            this._target = target;
        }
        if (this._language == null) {
            Locale locale = this._deploymentManager.getCurrentLocale();
            if (locale != null) {
                this._language = locale.getLanguage();
            }
            if (this._language == null || this._language.length() == 0) {
                this._language = "en";
            }
        }
    }

    public void removeDConfigBean(DConfigBean bean) throws BeanNotFoundException {
        if (this._module != null) {
            super.removeDConfigBean(bean);
            this._module = null;
        }
    }

    public String getModuleId() {
        return this._moduleId;
    }

    public String getModuleIdWithoutExt() {
        if (this._moduleId.indexOf(".") > 0) {
            return this._moduleId.substring(0, this._moduleId.indexOf("."));
        }
        return this._moduleId;
    }

    public void setApplicationId(String applicationId) throws ConfigurationException {
        if (!DeplConfiguration.validateAppName(applicationId)) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("invalidArgumentValue", new String[]{applicationId}));
        }
        this._applicationId = applicationId;
    }

    public String getApplicationId() {
        return this._applicationId;
    }

    public String defaultApplicationId() {
        return "";
    }

    public void setWebSiteBinding(WebSiteType webSiteBinding) throws ConfigurationException {
        if (webSiteBinding == null) {
            this._webSiteBinding = new WebSiteType(this);
            this._webSiteBinding.setValue("");
        } else {
            this._webSiteBinding = webSiteBinding;
        }
    }

    public WebSiteType getWebSiteBinding() {
        if (this._webSiteBinding == null) {
            this._webSiteBinding = new WebSiteType(this);
            String[] webSiteTags = this._webSiteBinding.getTags();
            if (webSiteTags != null && webSiteTags.length > 0) {
                try {
                    this._webSiteBinding.setValue(webSiteTags[0]);
                }
                catch (Throwable t) {
                    throw new ExtendedRuntimeException(t);
                }
            }
        }
        return this._webSiteBinding;
    }

    public void putWebSiteBindings(String moduleName, WebSiteBindingType[] webSiteBindings) {
        if (this._rootParent != null) {
            this._rootParent.putWebSiteBindings(moduleName, webSiteBindings);
        } else {
            this._webSiteBindings.put(moduleName, webSiteBindings);
        }
    }

    public Hashtable getWebSiteBindings() {
        return this._webSiteBindings;
    }

    public Hashtable getWebSiteBindingNames() {
        return this._webSiteBindingNames;
    }

    public void setWebSiteBindingNames(Hashtable webSiteBindingNames) {
        this._webSiteBindingNames = webSiteBindingNames;
    }

    public String[] getWebSiteNames(String moduleName) {
        block1: {
            Set webSiteNamesEntrySet;
            Iterator webSiteIt;
            if (this._webSiteBindingNames == null) {
                return null;
            }
            if (moduleName != "." || !(webSiteIt = (webSiteNamesEntrySet = this._webSiteBindingNames.entrySet()).iterator()).hasNext()) break block1;
            Map.Entry webSiteEntry = webSiteIt.next();
            moduleName = (String)webSiteEntry.getKey();
        }
        return (String[])this._webSiteBindingNames.get(moduleName);
    }

    public void setParentApp(AppType parentApp) throws ConfigurationException {
        this._parentApp = parentApp;
    }

    public AppType getParentApp() {
        return this._parentApp;
    }

    public void setConfigTarget(Target configTarget) throws ConfigurationException {
        this._target = configTarget;
    }

    public Target getTarget() {
        return this._target;
    }

    public void setDeployableObject(DeployableObject deployableObject) {
        this._deployableObject = deployableObject;
    }

    public void setInitFromDeployment(boolean initFromDeployment) throws ConfigurationException {
        this._initFromDeployment = initFromDeployment;
    }

    public boolean getInitFromDeployment() {
        return this._initFromDeployment;
    }

    public void setEnableIIOP(BooleanType enableIIOP) throws ConfigurationException {
        this._enableIIOP = enableIIOP;
    }

    public BooleanType getEnableIIOP() {
        return this._enableIIOP;
    }

    public BooleanType defaultEnableIIOP() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setRemoveArchive(BooleanType removeArchive) throws ConfigurationException {
        this._removeArchive = removeArchive;
    }

    public BooleanType getRemoveArchive() {
        return this._removeArchive;
    }

    public BooleanType defaultRemoveArchive() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void setFailureRecovery(BooleanType failureRecovery) throws ConfigurationException {
        this._failureRecovery = failureRecovery;
    }

    public BooleanType getFailureRecovery() {
        return this._failureRecovery;
    }

    public BooleanType defaultFailureRecovery() {
        try {
            return new BooleanType(this, "false");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void putDeploymentManager(DeplManager deploymentManager) {
        this._deploymentManager = deploymentManager;
    }

    public DeplManager getDeploymentManager() {
        return this._deploymentManager;
    }

    protected DConfigBean buildSAChild(String xpath, DDBean bean, ConfigBeanNode parent, Node node) {
        throw new UnsupportedOperationException();
    }

    public DConfigBean getDConfigBean(DDBeanRoot ddBeanRoot) {
        if (ddBeanRoot == null || ddBeanRoot.getFilename() == null) {
            return null;
        }
        if (this._otherConfigBeans == null) {
            return null;
        }
        return (DConfigBean)this._otherConfigBeans.get(ddBeanRoot.getFilename());
    }

    public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
        if (!bean.getXpath().equals("/" + this._xpaths[0])) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("getDConfigBeanArg", new String[]{bean.getXpath(), "/"}));
        }
        try {
            Vector childMaps = this.getChildBean(this._configXpaths[0]);
            if (childMaps == null) {
                throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("missingDConfigBean", new String[]{bean.getText(), this._configXpaths[0]}));
            }
            if (childMaps.size() > 0) {
                ConfigBeanNode configBean = (ConfigBeanNode)childMaps.elementAt(0);
                if (configBean.fetchDDBean() == null) {
                    configBean.putDDBean(bean);
                }
                return configBean;
            }
            ConfigBeanNode configBean = this.isEmbedded() ? (ConfigBeanNode)this.buildChild(this._configXpaths[0], bean, this, this.getNode()) : (ConfigBeanNode)this.buildSAChild(this._configXpaths[0], bean, this, this.getNode());
            childMaps.add(configBean);
            return configBean;
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
    }

    public boolean isEmbedded() {
        return this._rootParent != null;
    }

    public ConfigBeanRootNode getRootParent() {
        return this._rootParent;
    }

    public void dontSaveConfiguration(boolean dontSave) {
        this._dontSaveConfiguration = dontSave;
    }

    public boolean dontSaveConfiguration() {
        return this._dontSaveConfiguration;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._module != null) {
            this._module.writeXML(out, indentation);
        }
    }

    public abstract void writeConfig(PrintWriter var1) throws ExtendedRuntimeException;

    public static ConfigBeanRootNode createConf(DeployableObject deployableObject, String moduleID, DeplManager deplManager, ConfigBeanRootNode parent, String configContent) throws ConfigurationException {
        InputStream jaznStream;
        String loc;
        ConfigBeanRootNode depXml = null;
        DDBeanRoot beanRoot = deployableObject.getDDBeanRoot();
        ModuleType moduleType = deployableObject.getType();
        if (moduleType.equals(ModuleType.EAR)) {
            depXml = new EarDepXml(moduleID, (DDBean)beanRoot, deplManager);
        } else if (moduleType.equals(ModuleType.EJB)) {
            depXml = new EjbDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
        } else if (moduleType.equals(ModuleType.WAR)) {
            depXml = new WarDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
        } else if (moduleType.equals(ModuleType.CAR)) {
            depXml = new CarDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
        } else if (moduleType.equals(ModuleType.RAR)) {
            depXml = new RarDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
        }
        depXml.setDeployableObject(deployableObject);
        XMLDocument doc = null;
        Element node = null;
        if (configContent == null) {
            try {
                doc = XMLUtils.parse(deployableObject, depXml.getDepXmlPath(), false);
            }
            catch (ExtendedRuntimeException exEx) {
                if (moduleID == null || moduleID.equals("") || moduleID.equals(".")) {
                    throw new ExtendedRuntimeException(System.getProperty("line.separator") + depXml.getDepXmlPath() + ":  ", exEx);
                }
                throw new ExtendedRuntimeException(System.getProperty("line.separator") + moduleID + ":  " + depXml.getDepXmlPath() + ":  ", exEx);
            }
        } else {
            doc = XMLUtils.parse(configContent, false);
        }
        if (doc != null) {
            node = doc.getDocumentElement();
        }
        depXml.setNode(node);
        depXml.init();
        if (deployableObject instanceof J2eeFile) {
            depXml.dontSaveConfiguration(((J2eeFile)deployableObject).noConfiguration());
        }
        String jaznDataPath = null;
        JaznConfigBean jaznConfigBean = ConfigBeanRootNode.getJaznXML(depXml);
        if (jaznConfigBean != null && (loc = jaznConfigBean.getLocation()) != null && loc.length() > 0) {
            jaznDataPath = "META-INF/" + jaznConfigBean.getLocation();
        }
        if (jaznDataPath != null && (jaznStream = deployableObject.getEntry(jaznDataPath)) != null) {
            try {
                doc = XMLUtils.parse(jaznStream, false);
            }
            catch (ExtendedRuntimeException exEx) {
                throw new ExtendedRuntimeException(System.getProperty("line.separator") + jaznDataPath + ":  ", exEx);
            }
            if (doc != null) {
                node = doc.getDocumentElement();
                depXml.parseJaznData(node);
            }
        }
        return depXml;
    }

    private static XMLSchema getSchema(File schemaFile) throws ConfigurationException {
        if (schemaFile != null && schemaFile.exists()) {
            try {
                URI uri = schemaFile.toURI();
                URL url = uri.toURL();
                XSDBuilder xsdBuilder = new XSDBuilder();
                return xsdBuilder.build(url);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
        return null;
    }

    private static XMLSchema getSchema(URL url) throws ConfigurationException {
        try {
            XSDBuilder xsdBuilder = new XSDBuilder();
            return xsdBuilder.build(url);
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
    }

    public static ConfigBeanRootNode createWSConf(DeployableObject deployableObject, String moduleID, DeplManager deplManager, ConfigBeanRootNode parent, ConfigBeanRootNode peer, String configContent) throws ConfigurationException {
        WSDepXml depXml;
        block23: {
            depXml = null;
            if (!(deployableObject instanceof J2eeFile)) {
                return null;
            }
            ModuleType moduleType = deployableObject.getType();
            DDBeanRoot beanRoot = null;
            try {
                if (moduleType.equals(ModuleType.EAR)) {
                    return null;
                }
                if (moduleType.equals(ModuleType.EJB)) {
                    try {
                        beanRoot = deployableObject.getDDBeanRoot("META-INF/webservices.xml");
                        depXml = new WSDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
                        if (peer != null) {
                            peer.setDConfigBean("META-INF/webservices.xml", depXml);
                        }
                        break block23;
                    }
                    catch (FileNotFoundException ex) {
                        return null;
                    }
                }
                if (moduleType.equals(ModuleType.WAR)) {
                    try {
                        beanRoot = deployableObject.getDDBeanRoot("WEB-INF/webservices.xml");
                        depXml = new WSDepXml(moduleID, (DDBean)beanRoot, deplManager, parent);
                        if (peer != null) {
                            peer.setDConfigBean("WEB-INF/webservices.xml", depXml);
                        }
                        break block23;
                    }
                    catch (FileNotFoundException ex) {
                        return null;
                    }
                }
                if (moduleType.equals(ModuleType.CAR)) {
                    return null;
                }
                if (moduleType.equals(ModuleType.RAR)) {
                    return null;
                }
            }
            catch (Throwable t) {
                throw new ExtendedRuntimeException(t);
            }
        }
        XMLDocument doc = null;
        if (configContent == null) {
            String depName = ((ConfigBeanRootNode)depXml).getDepXmlPath();
            if (depName == null) {
                return null;
            }
            InputStream strm = deployableObject.getEntry(depName);
            if (strm != null) {
                try {
                    doc = XMLUtils.parse(strm, false);
                }
                catch (ExtendedRuntimeException exEx) {
                    if (moduleID == null || moduleID.equals("") || moduleID.equals(".")) {
                        throw new ExtendedRuntimeException(System.getProperty("line.separator") + depName + ":  ", exEx);
                    }
                    throw new ExtendedRuntimeException(System.getProperty("line.separator") + moduleID + ":  " + depName + ":  ", exEx);
                }
            }
        } else {
            doc = XMLUtils.parse(new BufferedReader(new StringReader(configContent)), false);
        }
        Element node = null;
        if (doc != null) {
            node = doc.getDocumentElement();
        }
        depXml.setNode(node);
        ((ConfigBeanRootNode)depXml).init();
        if (deployableObject instanceof J2eeFile) {
            depXml.dontSaveConfiguration(((J2eeFile)deployableObject).noConfiguration());
        }
        return depXml;
    }

    public void setDConfigBean(String path, DConfigBean bean) {
        if (this._otherConfigBeans == null) {
            this._otherConfigBeans = new Hashtable();
        }
        if (path != null) {
            this._otherConfigBeans.put(path, bean);
        }
    }

    public abstract String getDepXmlPath();

    public abstract void init() throws ConfigurationException;

    public void initJaznData(String jaznData) throws ConfigurationException {
        if (jaznData == null) {
            this._jaznRealms = new Hashtable();
            return;
        }
        if (this.getJaznDataPath() == null) {
            return;
        }
        StringReader stringReader = new StringReader(jaznData);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        XMLDocument doc = null;
        try {
            doc = XMLUtils.parse(bufferedReader, false);
        }
        catch (ExtendedRuntimeException exEx) {
            throw new ExtendedRuntimeException(System.getProperty("line.separator") + "jazn-data:  ", exEx);
        }
        if (doc != null) {
            this.parseJaznData(doc.getDocumentElement());
        }
    }

    public String getJaznDataPath() {
        return null;
    }

    private static Node getFirstNode(Node node, String nodeName) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            String name = node.getNodeName();
            if (!name.equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public void initJaznDataFromEntry(String entry) throws ConfigurationException {
        XMLDocument doc = null;
        Element node = null;
        this.initJaznData(null);
        if (entry != null && entry.length() > 0 && this._deployableObject != null) {
            String jaznDataPath = "META-INF/" + entry;
            InputStream jaznStream = this._deployableObject.getEntry(jaznDataPath);
            if (jaznStream == null && entry.indexOf("./") == 0) {
                while (entry.indexOf("./") == 0) {
                    entry = entry.substring(2);
                }
                jaznDataPath = "META-INF/" + entry;
                jaznStream = this._deployableObject.getEntry(jaznDataPath);
            }
            if (jaznStream != null) {
                try {
                    doc = XMLUtils.parse(jaznStream, false);
                }
                catch (ExtendedRuntimeException exEx) {
                    throw new ExtendedRuntimeException(System.getProperty("line.separator") + jaznDataPath + ":  ", exEx);
                }
                if (doc != null) {
                    node = doc.getDocumentElement();
                    this.parseJaznData(node);
                }
            }
        }
    }

    private void parseJaznData(Node node) throws ConfigurationException {
        Hashtable<String, JaznRealm> jaznRealms = null;
        String defaultRealmName = null;
        try {
            jaznRealms = new Hashtable<String, JaznRealm>();
            if (node != null) {
                node = ConfigBeanRootNode.getFirstNode(node, "jazn-realm");
            }
            if (node != null) {
                NodeList realmNodes = node.getChildNodes();
                for (int realm = 0; realm < realmNodes.getLength(); ++realm) {
                    String nodeName;
                    int i;
                    NodeList nodes;
                    String realmName;
                    Node realmNameNode;
                    node = realmNodes.item(realm);
                    if (!"realm".equals(node.getNodeName()) || (realmNameNode = ConfigBeanRootNode.getFirstNode(node, "name")) == null || (realmName = XMLUtils.getValue(realmNameNode)) == null || realmName.length() == 0) continue;
                    if (defaultRealmName == null) {
                        defaultRealmName = realmName;
                    }
                    Node usersNode = null;
                    Node groupsNode = null;
                    if (node != null) {
                        usersNode = ConfigBeanRootNode.getFirstNode(node, "users");
                        groupsNode = ConfigBeanRootNode.getFirstNode(node, "roles");
                    }
                    String name = null;
                    String description = null;
                    HashSet<User> users = new HashSet<User>();
                    HashSet<Group> groups = new HashSet<Group>();
                    if (usersNode != null) {
                        nodes = usersNode.getChildNodes();
                        for (i = 0; i < nodes.getLength(); ++i) {
                            Node userNode = nodes.item(i);
                            nodeName = userNode.getNodeName();
                            if (!nodeName.equals("user")) continue;
                            NodeList userNodes = userNode.getChildNodes();
                            for (int n = 0; n < userNodes.getLength(); ++n) {
                                node = userNodes.item(n);
                                nodeName = node.getNodeName();
                                if (nodeName.equals("name")) {
                                    name = XMLUtils.getValue(node);
                                }
                                if (!nodeName.equals("description")) continue;
                                description = XMLUtils.getValue(node);
                            }
                            if (name == null || name.length() <= 0) continue;
                            User user = new User(name, description);
                            users.add(user);
                        }
                    }
                    if (groupsNode != null) {
                        nodes = groupsNode.getChildNodes();
                        for (i = 0; i < nodes.getLength(); ++i) {
                            Node groupNode = nodes.item(i);
                            nodeName = groupNode.getNodeName();
                            if (!nodeName.equals("role")) continue;
                            NodeList groupNodes = groupNode.getChildNodes();
                            for (int n = 0; n < groupNodes.getLength(); ++n) {
                                node = groupNodes.item(n);
                                nodeName = node.getNodeName();
                                if (nodeName.equals("name")) {
                                    name = XMLUtils.getValue(node);
                                }
                                if (!nodeName.equals("description")) continue;
                                description = XMLUtils.getValue(node);
                            }
                            if (name == null || name.length() <= 0) continue;
                            Group group = new Group(name, description);
                            groups.add(group);
                        }
                    }
                    JaznRealm newRealm = new JaznRealm(users, groups);
                    jaznRealms.put(realmName, newRealm);
                }
            }
        }
        catch (Throwable t) {
            throw new ConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("noXmlDoc", new String[]{"jazn-realm"}));
        }
        this._defaultRealmName = jaznRealms != null && jaznRealms.size() == 1 ? defaultRealmName : null;
        this._jaznRealms = jaznRealms;
    }

    public String getDefaultRealm() {
        return this._defaultRealmName;
    }

    public Set getUsers() {
        JaznRealm jaznRealm = this.getJaznRealm();
        if (jaznRealm != null) {
            return jaznRealm.getUsers();
        }
        return null;
    }

    public Set getGroups() {
        JaznRealm jaznRealm = this.getJaznRealm();
        if (jaznRealm != null) {
            return jaznRealm.getGroups();
        }
        return null;
    }

    private static JaznConfigBean getJaznXML(ConfigBeanRootNode depXml) {
        StringType provider;
        ApplicationConfigBean appConfigBean;
        JaznConfigBean jaznConfigBean;
        Vector appConfigBeans = depXml.getChildBean("orion-application");
        if (appConfigBeans != null && appConfigBeans.size() > 0 && (jaznConfigBean = (appConfigBean = (ApplicationConfigBean)appConfigBeans.elementAt(0)).getJazn()) != null && ((provider = jaznConfigBean.getProvider()) == null || "XML".equals(provider.getValue()))) {
            return jaznConfigBean;
        }
        return null;
    }

    private JaznRealm getJaznRealm() {
        String defaultRealm;
        if (this._jaznRealms == null) {
            return null;
        }
        if (this._jaznRealms.size() == 0) {
            return null;
        }
        Object realm = null;
        JaznConfigBean jaznConfigBean = ConfigBeanRootNode.getJaznXML(this);
        if (jaznConfigBean != null && (defaultRealm = jaznConfigBean.getDefaultRealm()) != null && defaultRealm.length() > 0) {
            JaznRealm jaznRealm = (JaznRealm)this._jaznRealms.get(defaultRealm);
            return jaznRealm;
        }
        return null;
    }

    public boolean hasEntry(String entry) {
        if (entry == null || entry.length() == 0) {
            return false;
        }
        if (this._deployableObject != null) {
            Enumeration entries = this._deployableObject.entries();
            while (entries.hasMoreElements()) {
                ZipEntry nextZipEntry;
                Object nextEntry = entries.nextElement();
                if (!(nextEntry instanceof ZipEntry ? !(nextZipEntry = (ZipEntry)nextEntry).isDirectory() && entry.equals(nextZipEntry.getName()) : entry.equals((String)nextEntry))) continue;
                return true;
            }
        }
        return false;
    }

    public String getLanguage() {
        return this._language;
    }

    private static XMLSchema getSchema(String firstElem) {
        if ("orion-application".equals(firstElem)) {
            return _earSchema;
        }
        if ("orion-ejb-jar".equals(firstElem)) {
            return _ejbSchema;
        }
        if ("orion-web-app".equals(firstElem)) {
            return _warSchema;
        }
        if ("orion-application-client".equals(firstElem)) {
            return _carSchema;
        }
        if ("oc4j-connector-factories".equals(firstElem)) {
            return _rarSchema;
        }
        if ("oracle-webservices".equals(firstElem)) {
            return _wsSchema;
        }
        return null;
    }

    public static String getDoc(String xpath) {
        if (xpath == null || xpath.length() == 0) {
            return null;
        }
        try {
            return FormattingResourceBundle.DeploymentMessages.getString(xpath);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String getPropertyDoc(String xpath, String propertyName) {
        if (xpath == null || xpath.length() == 0) {
            return null;
        }
        String propertyXpath = ConfigBeanXpathInfo.getPropertyXpath(xpath, propertyName);
        if (propertyXpath == null) {
            return null;
        }
        if (propertyXpath.indexOf("@") >= 0) {
            if (propertyXpath.equals("@")) {
                xpath = xpath + "/" + propertyName;
                propertyXpath = null;
            } else {
                StringTokenizer tokenizer = new StringTokenizer(propertyXpath, "@");
                String additionalXpath = tokenizer.nextToken();
                xpath = xpath + "/" + additionalXpath;
                propertyXpath = tokenizer.hasMoreElements() ? tokenizer.nextToken() : null;
            }
        }
        try {
            if (propertyXpath != null) {
                xpath = xpath + "/" + propertyXpath;
            }
            return FormattingResourceBundle.DeploymentMessages.getString(xpath);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public static String getPropertyDoc(String language, String xpath, String propertyName) {
        StringTokenizer tokenizer;
        if (xpath == null || xpath.length() == 0) {
            return null;
        }
        String propertyXpath = ConfigBeanXpathInfo.getPropertyXpath(xpath, propertyName);
        if (propertyXpath == null) {
            return null;
        }
        if (propertyXpath.indexOf("@") >= 0) {
            if (propertyXpath.equals("@")) {
                propertyXpath = null;
            } else {
                tokenizer = new StringTokenizer(propertyXpath, "@");
                String additionalXpath = tokenizer.nextToken();
                xpath = xpath + "/" + additionalXpath;
                propertyXpath = tokenizer.hasMoreElements() ? tokenizer.nextToken() : null;
            }
        }
        if (!(tokenizer = new StringTokenizer(xpath, "/")).hasMoreElements()) {
            return null;
        }
        String firstName = tokenizer.nextToken();
        XSDElement elem = ConfigBeanRootNode.getXSDElement(xpath);
        if (elem == null) {
            return null;
        }
        if (propertyXpath == null || propertyXpath.length() == 0) {
            return ConfigBeanRootNode.getDoc(language, elem, firstName);
        }
        return ConfigBeanRootNode.getPropertyDoc(language, elem, firstName, propertyXpath);
    }

    public static String getDoc(String language, String xpath) {
        if (xpath == null || xpath.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/");
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        String firstName = tokenizer.nextToken();
        XSDElement elem = ConfigBeanRootNode.getXSDElement(xpath);
        if (elem == null) {
            return null;
        }
        return ConfigBeanRootNode.getDoc(language, elem, firstName);
    }

    private static XSDElement getXSDElement(String xpath) {
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/");
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        String elemName = tokenizer.nextToken();
        String firstName = elemName;
        if (ConfigBeanRootNode.getSchema(firstName) == null) {
            return null;
        }
        XSDElement elem = null;
        elem = ConfigBeanRootNode.getSchema(firstName).getElement("", elemName);
        if (elem == null) {
            return null;
        }
        int type = elem.getNodeType();
        int nodeType = elem.getType().getNodeType();
        block0: while (tokenizer.hasMoreElements() && nodeType == 1) {
            XSDComplexType complexType = (XSDComplexType)elem.getType();
            XSDNode[] childElems = complexType.getElementSet();
            elemName = tokenizer.nextToken();
            if (childElems == null) {
                return null;
            }
            for (int n = 0; n < childElems.length; ++n) {
                XSDNode childElem = childElems[n];
                if (childElem instanceof XSDGroup) {
                    XSDGroup group = (XSDGroup)childElem;
                    Vector groupElems = group.getNodeVector();
                    for (int g = 0; g < groupElems.size(); ++g) {
                        XSDElement groupElemNode;
                        XSDNode groupNode = (XSDNode)groupElems.elementAt(g);
                        if (!(groupNode instanceof XSDElement) || !(groupElemNode = (XSDElement)groupNode).getName().equals(elemName)) continue;
                        childElem = groupElemNode;
                        break;
                    }
                }
                if (childElem.getName() == null) {
                    if (childElem.getNodeType() != 0) continue;
                    elem = ConfigBeanRootNode.getSchema(firstName).getElement("", elemName);
                    if (elem != null) continue block0;
                    return null;
                }
                if (!childElem.getName().equals(elemName)) continue;
                String refName = elem.getRefLocalname();
                elem = (XSDElement)childElem;
                if (elem == null) {
                    return null;
                }
                type = elem.getNodeType();
                nodeType = elem.getType().getNodeType();
                continue block0;
            }
        }
        return elem;
    }

    private static String getPropertyDoc(String language, XSDElement elem, String firstName, String propertyName) {
        XSDAnnotation annotation = null;
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        int nodeType = elem.getType().getNodeType();
        if (nodeType == 1) {
            XSDComplexType complexType = (XSDComplexType)elem.getType();
            XSDAttribute[] attrs = complexType.getAttributeDeclarations();
            if (attrs == null) {
                return null;
            }
            for (int att = 0; att < attrs.length; ++att) {
                if (attrs[att] == null || !propertyName.equals(attrs[att].getName())) continue;
                annotation = attrs[att].getAnnotation();
                if (annotation == null) break;
                Vector userInfo = annotation.getUserInformation();
                String noLangDoc = null;
                for (int n = 0; n < userInfo.size(); ++n) {
                    XMLElement infoElem = (XMLElement)userInfo.elementAt(n);
                    String lang = XMLUtils.getAttribute((Node)infoElem, "xml:lang");
                    if (lang != null && lang.length() > 0) {
                        if (!lang.equals(language)) continue;
                        return XMLUtils.getValue((Node)infoElem);
                    }
                    noLangDoc = XMLUtils.getValue((Node)infoElem);
                }
                return noLangDoc;
            }
        }
        return null;
    }

    private static String getDoc(String language, XSDElement elem, String firstName) {
        XSDAnnotation annotation = elem.getAnnotation();
        if (annotation != null) {
            Vector userInfo = annotation.getUserInformation();
            String noLangDoc = null;
            for (int n = 0; n < userInfo.size(); ++n) {
                XMLElement infoElem = (XMLElement)userInfo.elementAt(n);
                String lang = XMLUtils.getAttribute((Node)infoElem, "xml:lang");
                if (lang != null && lang.length() > 0) {
                    if (!lang.equals(language)) continue;
                    return XMLUtils.getValue((Node)infoElem);
                }
                noLangDoc = XMLUtils.getValue((Node)infoElem);
            }
            return noLangDoc;
        }
        XSDNode elemType = elem.getType();
        if (elemType != null && (annotation = elemType.getAnnotation()) != null) {
            Vector userInfo = annotation.getUserInformation();
            String noLangDoc = null;
            for (int n = 0; n < userInfo.size(); ++n) {
                XMLElement infoElem = (XMLElement)userInfo.elementAt(n);
                String lang = XMLUtils.getAttribute((Node)infoElem, "xml:lang");
                if (lang != null && lang.length() > 0) {
                    if (!lang.equals(language)) continue;
                    return XMLUtils.getValue((Node)infoElem);
                }
                noLangDoc = XMLUtils.getValue((Node)infoElem);
            }
            return noLangDoc;
        }
        String refName = elem.getRefLocalname();
        if (refName != null) {
            elem = ConfigBeanRootNode.getSchema(firstName).getElement("", refName);
            if (elem == null) {
                return null;
            }
            annotation = elem.getAnnotation();
            if (annotation != null) {
                Vector userInfo = annotation.getUserInformation();
                String noLangDoc = null;
                for (int n = 0; n < userInfo.size(); ++n) {
                    XMLElement infoElem = (XMLElement)userInfo.elementAt(n);
                    String lang = XMLUtils.getAttribute((Node)infoElem, "xml:lang");
                    if (lang != null && lang.length() > 0) {
                        if (!lang.equals(language)) continue;
                        return XMLUtils.getValue((Node)infoElem);
                    }
                    noLangDoc = XMLUtils.getValue((Node)infoElem);
                }
                return noLangDoc;
            }
        }
        return null;
    }

    private class JaznRealm {
        HashSet _users = null;
        HashSet _groups = null;

        public JaznRealm(HashSet users, HashSet groups) {
            this._users = users;
            this._groups = groups;
        }

        public HashSet getUsers() {
            return this._users;
        }

        public HashSet getGroups() {
            return this._groups;
        }
    }
}

