/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ClasspathTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ClasspathType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class ClasspathsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_CLASSPATH_MENU_STRING = "Add Classpath";
    private JMenuItem _addClasspathMenuItem;
    private ClasspathType[] classpathsType = new ClasspathType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ClasspathsTreeNode(ConfigTreeNode rootNode, MultipleType classpaths) {
        super(classpaths);
        this.setRootNode(rootNode);
        this._parentBean = classpaths.getConfigParent();
        this._addClasspathMenuItem = new JMenuItem(ADD_CLASSPATH_MENU_STRING);
        this._addClasspathMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addClasspathMenuItem.setFont(ClasspathsTreeNode.getFont());
        this._addClasspathMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addClasspathMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getClasspaths", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addClasspath", ClasspathType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeClasspath", ClasspathType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Classpaths";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ClasspathType[] classpaths = (ClasspathType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (classpaths != null) {
                for (int i = 0; i < classpaths.length; ++i) {
                    ClasspathType classpath = classpaths[i];
                    if (classpath == null) continue;
                    ClasspathTreeNode classpathTreeNode = new ClasspathTreeNode(this.getRootNode(), classpath);
                    this.addChild(classpathTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ClasspathType newClasspath;
            if (event.getActionCommand().equals(ADD_CLASSPATH_MENU_STRING) && this.showAddDialog(newClasspath = new ClasspathType(this._parentBean), ADD_CLASSPATH_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newClasspath);
                ClasspathTreeNode newNode = new ClasspathTreeNode(this, newClasspath);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ClasspathTreeNode) {
            try {
                ClasspathType classpath = (ClasspathType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, classpath);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

