/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.status;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.spi.ConfigSetSynchronizer;
import oracle.oc4j.admin.deploy.spi.InternalDeployerCallBack;
import oracle.oc4j.admin.deploy.spi.TargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.status.DeploymentStatusImpl;
import oracle.oc4j.admin.deploy.spi.status.ExtendedProgressEvent;
import oracle.oc4j.admin.deploy.spi.status.ProprietaryClientConfigurationImpl;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.management.mejb.ProprietaryManagement;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class ProgressObjectImpl
implements ProgressObject,
NotificationListener {
    private static Logger logger_ = TraceLogger.getLogger((Class)ProgressObjectImpl.class);
    private InternalDeployerCallBack callBack_ = null;
    private DeploymentStatusImpl status_ = null;
    private Map listeners_ = null;
    protected Management mejb_ = null;
    protected Set resultTargetModuleIDs_ = null;
    private ObjectName targetObject_ = null;
    private List inputStreamsToClose_ = null;
    private Vector progressEvents_ = null;
    private CommandType cmdType_;
    private ConfigSetSynchronizer clustSynchro_ = null;
    private long lastNotificationSequenceNumber_ = 0L;

    public ProgressObjectImpl(Management mejb, InternalDeployerCallBack callback, CommandType cmd) {
        this.callBack_ = callback;
        this.cmdType_ = cmd;
        this.status_ = new DeploymentStatusImpl(cmd);
        this.listeners_ = new HashMap();
        this.resultTargetModuleIDs_ = new HashSet();
        this.mejb_ = mejb;
        this.inputStreamsToClose_ = new ArrayList(5);
        this.progressEvents_ = new Vector();
    }

    public ProgressObjectImpl(Management mejb, InternalDeployerCallBack callback, CommandType cmd, ObjectName tgt) {
        this.callBack_ = callback;
        this.cmdType_ = cmd;
        this.status_ = new DeploymentStatusImpl(cmd);
        this.listeners_ = new HashMap();
        this.resultTargetModuleIDs_ = new HashSet();
        this.mejb_ = mejb;
        this.targetObject_ = tgt;
        this.inputStreamsToClose_ = new ArrayList(5);
        this.progressEvents_ = new Vector();
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.status_;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        TargetModuleID[] res = new TargetModuleIDImpl[this.resultTargetModuleIDs_.size()];
        Iterator iter = this.resultTargetModuleIDs_.iterator();
        int index = 0;
        while (iter.hasNext()) {
            res[index++] = (TargetModuleIDImpl)iter.next();
        }
        return res;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        return new ProprietaryClientConfigurationImpl(this.mejb_, id);
    }

    public boolean isCancelSupported() {
        return this.cmdType_ == CommandType.DISTRIBUTE;
    }

    public void cancel() throws OperationUnsupportedException {
        this.status_.setAction(ActionType.CANCEL);
        this.status_.setMessage("Operation canceled");
        this.callBack_.cancel();
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        this.status_.setAction(ActionType.STOP);
        this.status_.setMessage("Operation stopped");
        this.callBack_.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        Map map = this.listeners_;
        synchronized (map) {
            this.listeners_.put(pol, pol);
            if (pol instanceof ConfigSetSynchronizer) {
                this.clustSynchro_ = (ConfigSetSynchronizer)pol;
                this.clustSynchro_.setProgressObject(this);
            }
            if (this.progressEvents_.size() != 0) {
                for (int i = 0; i < this.progressEvents_.size(); ++i) {
                    pol.handleProgressEvent((ProgressEvent)this.progressEvents_.elementAt(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener pol) {
        Map map = this.listeners_;
        synchronized (map) {
            this.listeners_.remove(pol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handback) {
        ProgressEvent event = this.NotificationToProgressEvent(notification);
        Map map = this.listeners_;
        synchronized (map) {
            HashMap listenersCopy = (HashMap)((HashMap)this.listeners_).clone();
            Iterator iter = listenersCopy.values().iterator();
            while (iter.hasNext()) {
                ProgressListener listener = (ProgressListener)iter.next();
                listener.handleProgressEvent(event);
            }
            this.progressEvents_.add(event);
        }
    }

    public void reportError(Throwable t) {
        block8: {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(buf);
            Throwable realCause = DeploymentUtils.getMostInnerCause(t);
            if (realCause.getMessage() == null) {
                pw.println(realCause);
            } else {
                pw.println(realCause.getMessage());
            }
            pw.flush();
            String errorStack = buf.toString();
            this.status_.setMessage("Operation failed with error:\n" + errorStack);
            this.status_.setState(StateType.FAILED);
            if (this.progressEvents_.size() == 0) {
                ProgressEvent event = new ProgressEvent((Object)"Error", null, (DeploymentStatus)this.status_);
                Notification not = new Notification("Error", event, 0L);
                this.handleNotification(not, null);
            }
            try {
                this.mejb_.getListenerRegistry().removeNotificationListener(this.getMBeanObjectName(), (NotificationListener)this);
            }
            catch (ListenerNotFoundException e) {
            }
            catch (InstanceNotFoundException e) {
            }
            catch (RemoteException e) {
                if (!logger_.isLoggable(Level.FINE)) break block8;
                logger_.log(Level.FINE, e.getMessage(), e);
            }
        }
        this.callBack_.release();
        this.cleanOnCompletion();
    }

    protected void reportOperationComplete() {
        try {
            try {
                this.mejb_.getListenerRegistry().removeNotificationListener(this.getMBeanObjectName(), (NotificationListener)this);
            }
            catch (ListenerNotFoundException e) {
                // empty catch block
            }
            this.status_.setState(StateType.COMPLETED);
            this.callBack_.release();
            this.cleanOnCompletion();
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    protected void addInputStreamToCloseOnCompletion(InputStream in) {
        this.inputStreamsToClose_.add(in);
    }

    protected ObjectName getMBeanObjectName() throws RemoteException {
        if (this.targetObject_ != null) {
            return this.targetObject_;
        }
        return ((ProprietaryManagement)this.mejb_).getDomain().getDeployerName();
    }

    public void setMBeanObjectName(ObjectName name) {
        this.targetObject_ = name;
    }

    private ProgressEvent NotificationToProgressEvent(Notification notification) {
        TargetModuleIDImpl tgtMdID = null;
        String msg = notification.getMessage();
        if (msg != null) {
            this.status_.setMessage(msg);
        }
        ObjectName targetObject = null;
        Object obj = notification.getUserData();
        if (obj instanceof NotificationUserData) {
            NotificationUserData userData = (NotificationUserData)obj;
            targetObject = userData.getTargetObject();
            if (userData.getEventType() == 1) {
                this.reportError(userData.getError());
            }
            if (userData.getEventType() != 1 && targetObject != null) {
                tgtMdID = new TargetModuleIDImpl(this.mejb_, targetObject);
                SharedModuleType mdType = this.callBack_.moduleType();
                if (mdType != null && (mdType.equals(SharedModuleType.EJB) || mdType.equals(SharedModuleType.WAR) || mdType.equals(SharedModuleType.CAR))) {
                    if (this.cmdType_ != CommandType.UNDEPLOY) {
                        tgtMdID = tgtMdID.getChildTargetModuleID()[0];
                    } else {
                        ObjectName moduleObjectName = this.composeModuleObjectName(targetObject, mdType);
                        tgtMdID = new TargetModuleIDImpl(this.mejb_, moduleObjectName);
                    }
                }
            }
            if (userData.getEventType() == 2 && userData.getNewState() == 100) {
                if (this.targetObject_ != null) {
                    this.resultTargetModuleIDs_.add(new TargetModuleIDImpl(this.mejb_, this.targetObject_));
                } else {
                    this.resultTargetModuleIDs_.add(tgtMdID);
                }
                if (userData.isDefaultApplicationRestartNeeded()) {
                    this.status_.setDefaultApplicationRestartNeeded(true);
                }
                if (this.clustSynchro_ != null) {
                    this.clustSynchro_.reportMainOperationComplete(this.status_);
                    if (msg != null) {
                        this.status_.setMessage(msg);
                    }
                }
                if (!this.status_.isFailed()) {
                    this.reportOperationComplete();
                }
            }
        }
        ExtendedProgressEvent progressEvent = new ExtendedProgressEvent(notification.getSource(), tgtMdID, new DeploymentStatusImpl(this.status_), notification.getTimeStamp(), notification.getSequenceNumber());
        this.lastNotificationSequenceNumber_ = notification.getSequenceNumber();
        return progressEvent;
    }

    private final void cleanOnCompletion() {
        Iterator iter = this.inputStreamsToClose_.iterator();
        while (iter.hasNext()) {
            InputStream f = (InputStream)iter.next();
            try {
                f.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportClusterSynchronization(String msg) {
        this.status_.setMessage(msg);
        ExtendedProgressEvent event = new ExtendedProgressEvent("", null, this.status_, System.currentTimeMillis(), this.lastNotificationSequenceNumber_++);
        Map map = this.listeners_;
        synchronized (map) {
            Iterator iter = this.listeners_.values().iterator();
            while (iter.hasNext()) {
                ProgressListener listener = (ProgressListener)iter.next();
                listener.handleProgressEvent((ProgressEvent)event);
            }
            this.progressEvents_.add(event);
        }
    }

    private ObjectName composeModuleObjectName(ObjectName appObjectName, SharedModuleType modType) {
        if (appObjectName == null || modType == null) {
            throw new IllegalArgumentException("composeModuleObjectName(), params should not be null");
        }
        if (!"J2EEApplication".equals(appObjectName.getKeyProperty("j2eeType"))) {
            throw new IllegalArgumentException("composeModuleObjectName(), appObjectName's j2eeType is not J2EEApplication: " + appObjectName);
        }
        if (modType.equals(SharedModuleType.EAR)) {
            throw new IllegalArgumentException("composeModuleObjectName(), the module type should not be EAR");
        }
        try {
            String domain = appObjectName.getDomain();
            String name = appObjectName.getKeyProperty("name");
            String server = appObjectName.getKeyProperty("J2EEServer");
            String type = null;
            if (modType.equals(SharedModuleType.EJB)) {
                type = "EJBModule";
            } else if (modType.equals(SharedModuleType.WAR)) {
                type = "WebModule";
            } else if (modType.equals(SharedModuleType.CAR)) {
                type = "AppClientModule";
            } else if (modType.equals(SharedModuleType.RAR)) {
                type = "ResourceAdapterModule";
            }
            String objStr = domain + ":J2EEApplication=" + name + ",J2EEServer=" + server + ",j2eeType=" + type + ",name=" + name;
            return new ObjectName(objStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to compse module object name from " + appObjectName + " because " + e.getMessage());
        }
    }

    public Throwable getFailedConnection() {
        return ((ProprietaryManagement)this.mejb_).getFailedConnection();
    }
}

