/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.File;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import oracle.oc4j.admin.deploy.cmdline.util.ApplicationStatus;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.shared.CodeSource;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;
import oracle.oc4j.admin.management.shared.WebBinding;

public class Oc4jDeploymentManager
extends ConnectedDeploymentManagerBase {
    private String _installLock = "install lock";
    private boolean _installSucceeded = false;
    private String _failureMessage;

    public Oc4jDeploymentManager(Domain domain) throws DeploymentManagerCreationException {
        super(domain);
    }

    public boolean modifySharedLibrary(Target[] targetList, String libraryName, String libraryVersion, Boolean libraryCompatible, File[] installCodeSources, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws InstantiationException {
        int i;
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        if (!this.sharedLibraryExists(libraryName, libraryVersion, oName)) {
            throw new InstantiationException("Shared library does not exist");
        }
        this.uploadCodeSources(targetList, libraryName, libraryVersion, installCodeSources);
        int numSources = (installCodeSources == null ? 0 : installCodeSources.length) + (addCodeSources == null ? 0 : addCodeSources.length);
        String[] codeSources = new String[numSources];
        if (installCodeSources != null) {
            for (i = 0; i < installCodeSources.length; ++i) {
                codeSources[i] = CodeSource.markAsUploaded(installCodeSources[i].getName());
            }
        }
        if (addCodeSources != null) {
            for (int j = 0; j < addCodeSources.length; ++j) {
                codeSources[i] = addCodeSources[j];
                ++i;
            }
        }
        boolean result = false;
        try {
            Object[] params = new Object[]{libraryName, libraryVersion, libraryCompatible, codeSources, removeCodeSources, addImports, removeImports};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", "java.lang.Boolean", "[Ljava.lang.String;", "[Ljava.lang.String;", "[Loracle.oc4j.admin.management.shared.ImportSharedLibrary;", "[Ljava.lang.String;"};
            Boolean bool = (Boolean)this.getMEJB().invoke(oName, "modifySharedLibrary", params, sigs);
            result = bool;
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error modifying shared library: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error modifying shared library: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        return result;
    }

    public void publishSharedLibrary(Target[] targetList, String name, String version, String parentName, String parentVersion, Boolean libraryCompatible, File[] installCodeSources, String[] addCodeSources, ImportSharedLibrary[] imports) throws InstantiationException {
        int i;
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        if (this.sharedLibraryExists(name, version, oName)) {
            throw new InstantiationException("Shared library already exists");
        }
        if (!(installCodeSources != null && installCodeSources.length != 0 || addCodeSources != null && addCodeSources.length != 0 || imports != null && imports.length != 0)) {
            throw new InstantiationException("Shared library must contain one code source or imported library");
        }
        this.uploadCodeSources(targetList, name, version, installCodeSources);
        int numSources = (installCodeSources == null ? 0 : installCodeSources.length) + (addCodeSources == null ? 0 : addCodeSources.length);
        String[] codeSources = new String[numSources];
        if (installCodeSources != null) {
            for (i = 0; i < installCodeSources.length; ++i) {
                codeSources[i] = CodeSource.markAsUploaded(installCodeSources[i].getName());
            }
        }
        if (addCodeSources != null) {
            for (int j = 0; j < addCodeSources.length; ++j) {
                codeSources[i] = addCodeSources[j];
                ++i;
            }
        }
        try {
            Object[] params = new Object[]{name, version, parentName, parentVersion, libraryCompatible, codeSources, imports};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Boolean", "[Ljava.lang.String;", "[Loracle.oc4j.admin.management.shared.ImportSharedLibrary;"};
            this.getMEJB().invoke(oName, "publishSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error publishing shared library: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error publishing shared library: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void addImportSharedLibrary(TargetModuleID[] targetList, String name, String minVersion, String maxVersion) throws InstantiationException {
        ObjectName oName = ((ProprietaryTargetModuleID)targetList[0]).getObjectName();
        if (!oName.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication")) {
            throw new JMXRuntimeException("addImportSharedLibrary(appName, name, version), appName has to be a J2EEApplication!");
        }
        try {
            Object[] params = new Object[]{name, minVersion, maxVersion};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            this.getMEJB().invoke(oName, "addImportSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error importing shared library in application : " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error importing shared library in application: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void addRemoveInheritedSharedLibrary(TargetModuleID[] targetList, String name) throws InstantiationException {
        ObjectName oName = ((ProprietaryTargetModuleID)targetList[0]).getObjectName();
        if (!oName.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication")) {
            throw new JMXRuntimeException("addRemoveInheritedSharedLibrary(appName, name), appName has to be a J2EEApplication!");
        }
        try {
            Object[] params = new Object[]{name};
            String[] sigs = new String[]{"java.lang.String"};
            this.getMEJB().invoke(oName, "addRemoveInheritedSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error adding <remove-inherited> element to application: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error adding <remove-inherited> element to application: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void deleteRemoveInheritedSharedLibrary(TargetModuleID[] targetList, String name) throws InstantiationException {
        ObjectName oName = ((ProprietaryTargetModuleID)targetList[0]).getObjectName();
        if (!oName.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication")) {
            throw new JMXRuntimeException("deleteRemoveInheritedSharedLibrary(appName, name), appName has to be a J2EEApplication!");
        }
        try {
            Object[] params = new Object[]{name};
            String[] sigs = new String[]{"java.lang.String"};
            this.getMEJB().invoke(oName, "deleteRemoveInheritedSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error deleting <remove-inherited> element to application: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error deleting <remove-inherited> element to application: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void deleteImportSharedLibrary(TargetModuleID[] targetList, String name) throws InstantiationException {
        ObjectName oName = ((ProprietaryTargetModuleID)targetList[0]).getObjectName();
        if (!oName.getKeyProperty("j2eeType").equalsIgnoreCase("J2EEApplication")) {
            throw new JMXRuntimeException("deleteImportSharedLibrary(appName, name), appName has to be a J2EEApplication!");
        }
        try {
            Object[] params = new Object[]{name};
            String[] sigs = new String[]{"java.lang.String"};
            this.getMEJB().invoke(oName, "deleteImportSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error deleting an imported shared library from an application : " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error deleting an imported shared library from an application : " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public SharedLibrary[] getSharedLibraries(Target[] targetList) throws InstantiationException {
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        SharedLibrary[] libs = null;
        try {
            libs = (SharedLibrary[])this.getMEJB().getAttribute(oName, "sharedLibraries");
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error getting shared libraries: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error getting shared libraries: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadCodeSources(Target[] targetList, String name, String version, File[] codeSourceFiles) throws InstantiationException {
        int i;
        if (codeSourceFiles == null || codeSourceFiles.length == 0) {
            return;
        }
        if (codeSourceFiles != null) {
            for (i = 0; i < codeSourceFiles.length; ++i) {
                if (!codeSourceFiles[i].exists()) {
                    throw new InstantiationException("Specified code source file '" + codeSourceFiles[i].getPath() + "' does not exist");
                }
                if (!codeSourceFiles[i].isDirectory()) continue;
                throw new InstantiationException("Specified code source file '" + codeSourceFiles[i].getPath() + "' is a directory");
            }
        }
        for (i = 0; i < codeSourceFiles.length; ++i) {
            this._installSucceeded = false;
            this._failureMessage = null;
            ProgressListener pl = new ProgressListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleProgressEvent(ProgressEvent event) {
                    String string = Oc4jDeploymentManager.this._installLock;
                    synchronized (string) {
                        DeploymentStatus status = event.getDeploymentStatus();
                        if (status.isCompleted()) {
                            Oc4jDeploymentManager.this._installSucceeded = true;
                            Oc4jDeploymentManager.this._installLock.notify();
                        } else if (status.isFailed()) {
                            Oc4jDeploymentManager.this._failureMessage = status.getMessage();
                            Oc4jDeploymentManager.this._installLock.notify();
                        } else if (status.isRunning()) {
                            // empty if block
                        }
                    }
                }
            };
            this.internalInstallSharedLibrary(targetList, name, version, codeSourceFiles[i].getName(), codeSourceFiles[i], pl);
            String string = this._installLock;
            synchronized (string) {
                if (!this._installSucceeded && this._failureMessage == null) {
                    try {
                        this._installLock.wait();
                    }
                    catch (InterruptedException e) {
                        InstantiationException ie = new InstantiationException("Interrupted while waiting for code source to install");
                        ie.initCause(e);
                        throw ie;
                    }
                }
            }
            if (this._installSucceeded) continue;
            throw new InstantiationException("Installing code source " + codeSourceFiles[i].getName() + " failed: " + this._failureMessage);
        }
    }

    public boolean checkSharedLibraryExists(Target[] targetList, String name, String version) throws InstantiationException {
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        return this.sharedLibraryExists(name, version, oName);
    }

    private boolean sharedLibraryExists(String name, String version, ObjectName objName) throws InstantiationException {
        Object[] params = new Object[]{name, version};
        String[] sigs = new String[]{"java.lang.String", "java.lang.String"};
        Boolean result = null;
        try {
            result = (Boolean)this.getMEJB().invoke(objName, "checkSharedLibraryExists", params, sigs);
        }
        catch (MBeanException mbe) {
            InstantiationException ie = new InstantiationException("Error checking for shared library existence: " + mbe.getTargetException().getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error checking for shared library existence: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        return result;
    }

    private ProgressObject internalInstallSharedLibrary(Target[] targetList, String name, String version, String codeSource, Object input, ProgressListener listener) {
        try {
            ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
            Object[] params = new Object[]{name, name, version, codeSource};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            return this.install(codeSource, targetList, input, oName, "installSharedLibrary", params, sigs, listener);
        }
        catch (Throwable t) {
            throw new DeploymentRuntimeException(t);
        }
    }

    public void removeSharedLibrary(Target[] targetList, String name, String version) throws InstantiationException {
        try {
            ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
            Object[] params = new Object[]{name, version};
            String[] sigs = new String[]{"java.lang.String", "java.lang.String"};
            this.getMEJB().invoke(oName, "removeSharedLibrary", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error removing shared library: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error removing shared library: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void createJDBCConnectionPool(Target[] targetList, String applicationName, String name, String factoryClass, String user, String password, String url, List properties) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{name, factoryClass, user, password, url};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "createJDBCConnectionPool", params, sigs);
            if (properties == null) {
                return;
            }
            ObjectName jdbcResourceName = this.getObjectNameFromTargetList(targetList, "\"" + name + "\"", "JDBCResource", "resources");
            params = new Object[2];
            sigs = new String[]{String.class.getName(), String.class.getName()};
            for (int i = 0; i < properties.size() / 2; ++i) {
                params[0] = properties.get(i * 2);
                params[1] = properties.get(i * 2 + 1);
                this.getMEJB().invoke(jdbcResourceName, "addConnectionFactoryProperty", params, sigs);
            }
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException creating JDBC connection pool: " + mbe.getMessage() + " : " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception  creating JDBC connection pool: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void removeDataSourceConnectionPool(Target[] targetList, String applicationName, String name) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{name};
            String[] sigs = new String[]{String.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "removeDataSourceConnectionPool", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException removing JDBC connection pool: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception removing JDBC connection pool: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void createManagedDataSource(Target[] targetList, String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String connectionPoolName, String txLevel, String dbSchema, Boolean manageLocalTransactions) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{dataSourceName, user, password, jndiLocation, loginTimeout == null ? new Integer(0) : loginTimeout, connectionPoolName, txLevel == null ? "global" : txLevel, dbSchema, manageLocalTransactions == null ? new Boolean(true) : manageLocalTransactions};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "createManagedDataSource", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException creating managed datasource: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception creating managed datasource: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void removeManagedDataSource(Target[] targetList, String applicationName, String dataSourceName) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{dataSourceName};
            String[] sigs = new String[]{String.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "removeManagedDataSource", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException removing managed datasource: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception removing managed datasource: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void createNativeDataSource(Target[] targetList, String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String dataSourceClass, String url, Map properties) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{dataSourceName, user, password, jndiLocation, loginTimeout, dataSourceClass, url, properties};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), String.class.getName(), Map.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "createNativeDataSource", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException creating native datasource: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception creating native datasource: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void removeNativeDataSource(Target[] targetList, String applicationName, String dataSourceName) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{dataSourceName};
            String[] sigs = new String[]{String.class.getName()};
            this.getMEJB().invoke(applicationObjectName, "removeNativeDataSource", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException removing managed datasource: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception removing managed datasource: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String getDataSourcesDescriptor(Target[] targetList, String applicationName) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            return (String)this.getMEJB().getAttribute(applicationObjectName, "dataSourcesDescriptor");
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException getting datasource descriptor: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception getting datasource descriptor: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String listDataSources(Target[] targetList, String applicationName) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{};
            String[] sigs = new String[]{};
            return (String)this.getMEJB().invoke(applicationObjectName, "listDataSources", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException listing data sources: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception listing datasources: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String listDataSourceConnectionPools(Target[] targetList, String applicationName) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{};
            String[] sigs = new String[]{};
            return (String)this.getMEJB().invoke(applicationObjectName, "listDataSourceConnectionPools", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException listing data source connection pools: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception listing datasource connection pools: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String testDatabaseConnection(Target[] targetList, String applicationName, String sqlStatement, String factoryClass, String user, String password, String url) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            ObjectName applicationObjectName = this.getObjectNameFromTargetList(targetList, applicationName, "J2EEApplication", "deployedObjects");
            Object[] params = new Object[]{sqlStatement, factoryClass, user, password, url};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            return (String)this.getMEJB().invoke(applicationObjectName, "testDatabaseConnection", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException testing database connection:" + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception testing datasource connection:" + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String testConnectionPool(Target[] targetList, String applicationName, String connectionPoolName, String sqlStatement, String user, String password) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            Object[] params = null;
            String[] sigs = null;
            if (user == null) {
                params = new Object[]{sqlStatement};
                sigs = new String[]{String.class.getName()};
            } else {
                params = new Object[]{sqlStatement, user, password};
                sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
            }
            return (String)this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JDBCResource", connectionPoolName, applicationName, null), "testConnection", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException testing connection pool connection:" + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception testing connection pool connection:" + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public String testDataSource(Target[] targetList, String applicationName, String datasourceName, String sqlStatement, String user, String password) throws InstantiationException {
        try {
            if (applicationName == null) {
                applicationName = "default";
            }
            Object[] params = null;
            String[] sigs = null;
            if (user == null) {
                params = new Object[]{sqlStatement};
                sigs = new String[]{String.class.getName()};
            } else {
                params = new Object[]{sqlStatement, user, password};
                sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
            }
            return (String)this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JDBCResource", null, applicationName, datasourceName), "testConnection", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException testing datasource connection:" + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception testing datasource connection:" + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void addFactory(Target[] targetList, String domain, String location, String host, String port, String username, String password, String clientID, Boolean isXA) throws InstantiationException {
        try {
            Object[] params = new Object[]{domain, location, host, port, username, password, clientID, isXA};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.class.getName()};
            this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "addFactory", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error adding JMS factory: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error adding JMS factory: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void removeFactory(Target[] targetList, String location) throws InstantiationException {
        try {
            Object[] params = new Object[]{location};
            String[] sigs = new String[]{String.class.getName()};
            this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "removeFactory", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error removing JMS factory: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error removing JMS factory: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public List getConnectionFactories(Target[] targetList) throws InstantiationException {
        try {
            return (List)this.getMEJB().getAttribute(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "connectionFactories");
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error getting JMS connection factories : " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error getting JMS connection factories : " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void addDestination(Target[] targetList, String domain, String name, String location, String persistenceFile, String description) throws InstantiationException {
        try {
            Object[] params = new Object[]{domain, name, location, persistenceFile, description};
            String[] sigs = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "addDestination", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error adding destination: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error adding destination: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void removeDestination(Target[] targetList, String name, Boolean force, Boolean removePFile) throws InstantiationException {
        try {
            Object[] params = new Object[]{name, force, removePFile};
            String[] sigs = new String[]{String.class.getName(), Boolean.class.getName(), Boolean.class.getName()};
            this.getMEJB().invoke(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "removeDestination", params, sigs);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error removing destination: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error removing destination: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public List getDestinations(Target[] targetList) throws InstantiationException {
        try {
            return (List)this.getMEJB().getAttribute(this.getResourceObjectNameFromTargetList(targetList, "JMSAdministratorResource", null, null, null), "destinations");
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error getting destinations: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error getting destinations: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void shutdown(Target[] targetList) throws InstantiationException {
        try {
            this.getMEJB().invoke(((ProprietaryTarget)targetList[0]).getObjectName(), "stop", new Object[0], new String[0]);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException shutting down server : " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception shutting down server : " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public void restart(Target[] targetList) throws InstantiationException {
        try {
            this.getMEJB().invoke(((ProprietaryTarget)targetList[0]).getObjectName(), "start", new Object[0], new String[0]);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("MBeanException during restart: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Exception during restart: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    private ObjectName getObjectNameFromTargetList(Target[] targetList, String name, String type, String attributeName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        String[] objectNameStrings = (String[])this.getMEJB().getAttribute(oName, attributeName);
        for (int i = 0; i < objectNameStrings.length; ++i) {
            if (objectNameStrings[i].indexOf("j2eeType=" + type) <= -1 || objectNameStrings[i].indexOf("name=" + name) <= -1) continue;
            return new ObjectName(objectNameStrings[i]);
        }
        throw new InstanceNotFoundException("Unable to find Mbean : " + type + " : " + name);
    }

    private ObjectName[] getObjectNameArrayFromTargetList(Target[] targetList, String attributeName) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        String[] objectNameStrings = (String[])this.getMEJB().getAttribute(oName, attributeName);
        ObjectName[] onames = new ObjectName[objectNameStrings.length];
        for (int i = 0; i < objectNameStrings.length; ++i) {
            onames[i] = new ObjectName(objectNameStrings[i]);
        }
        return onames;
    }

    private ObjectName getResourceObjectNameFromTargetList(Target[] targetList, String resourceType, String resourceName, String applicationName, String jdbcDataSource) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        ObjectName oName = ((ProprietaryTarget)targetList[0]).getObjectName();
        String[] resourcesObjectNameStrings = (String[])this.getMEJB().getAttribute(oName, "resources");
        for (int i = 0; i < resourcesObjectNameStrings.length; ++i) {
            if (resourcesObjectNameStrings[i].indexOf("j2eeType=" + resourceType) == -1 || resourceName != null && resourcesObjectNameStrings[i].indexOf("name=\"" + resourceName.replaceAll("\"", "") + "\"") == -1 || applicationName != null && resourcesObjectNameStrings[i].indexOf("J2EEApplication=" + applicationName.replaceAll("\"", "")) == -1) continue;
            ObjectName objectName = new ObjectName(resourcesObjectNameStrings[i]);
            if (jdbcDataSource != null) {
                ObjectName jdbcDataSourceObjectName = null;
                String[] datasourceObjectNameStrings = (String[])this.getMEJB().getAttribute(objectName, "jdbcDataSources");
                for (int ii = 0; ii < datasourceObjectNameStrings.length; ++ii) {
                    if (datasourceObjectNameStrings[ii].indexOf("name=\"" + jdbcDataSource.replaceAll("\"", "") + "\"") <= -1) continue;
                    jdbcDataSourceObjectName = new ObjectName(datasourceObjectNameStrings[ii]);
                }
                if (jdbcDataSourceObjectName == null) continue;
                return jdbcDataSourceObjectName;
            }
            return objectName;
        }
        String exceptionString = null;
        if (jdbcDataSource != null) {
            return new ObjectName("oc4j:j2eeType=JDBCDataSource,name=\"" + jdbcDataSource + "\",JDBCResource=\"\"," + "J2EEApplication=" + applicationName + ",J2EEServer=standalone");
        }
        exceptionString = "Unable to find j2eeType=" + resourceType + (resourceName == null ? "" : " name=" + resourceName) + (applicationName == null ? "" : " J2EEApplication=" + applicationName) + " Mbean";
        throw new InstanceNotFoundException(exceptionString);
    }

    public Map getApplications(Target[] targetList, boolean verbose) throws InstantiationException {
        HashMap instanceAppMap = new HashMap();
        try {
            Vector<ApplicationStatus> applicationStatusVector = new Vector<ApplicationStatus>();
            ObjectName[] onames = this.getObjectNameArrayFromTargetList(targetList, "deployedObjects");
            for (int i = 0; i < onames.length; ++i) {
                ApplicationStatus applicationStatus = this.getApplicationStatus(onames[i], verbose);
                applicationStatusVector.add(applicationStatus);
            }
            instanceAppMap.put(this.getInstanceName(targetList), applicationStatusVector);
        }
        catch (MBeanException mbe) {
            Exception t = mbe.getTargetException();
            InstantiationException ie = new InstantiationException("Error getting applications: " + t.getMessage());
            ie.initCause(mbe.getTargetException());
            throw ie;
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error getting appliations: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        return instanceAppMap;
    }

    public Map getWebBindings(Target[] targetList, String siteName, boolean verbose) throws InstantiationException {
        HashMap instanceBindingsMap = new HashMap();
        try {
            Vector<ApplicationStatus> webBindingVector = new Vector<ApplicationStatus>();
            ObjectName[] onames = this.getObjectNameArrayFromTargetList(targetList, "j2eeWebSites");
            Vector<ObjectName> matchingWebSites = new Vector<ObjectName>();
            for (int i = 0; i < onames.length; ++i) {
                String currentSite = onames[i].getKeyProperty("name");
                if (siteName == null) {
                    matchingWebSites.add(onames[i]);
                    continue;
                }
                if (!siteName.equalsIgnoreCase(currentSite)) continue;
                matchingWebSites.add(onames[i]);
                break;
            }
            if (matchingWebSites.size() == 0) {
                throw new InstanceNotFoundException("Unable to find web site " + siteName + " in instance " + this.getInstanceName(targetList));
            }
            Object[] matchingWebSitesArray = matchingWebSites.toArray();
            for (int i = 0; i < matchingWebSitesArray.length; ++i) {
                ApplicationStatus webBindingStatus;
                WebBinding[] bindings = (WebBinding[])this.getMEJB().getAttribute((ObjectName)matchingWebSitesArray[i], "webApps");
                for (int j = 0; j < bindings.length; ++j) {
                    webBindingStatus = this.getWebBindingStatus(bindings[j]);
                    webBindingVector.add(webBindingStatus);
                }
                WebBinding binding = (WebBinding)this.getMEJB().getAttribute((ObjectName)matchingWebSitesArray[i], "defaultWebApp");
                webBindingStatus = this.getWebBindingStatus(binding);
                webBindingVector.add(webBindingStatus);
            }
            instanceBindingsMap.put(this.getInstanceName(targetList), webBindingVector);
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("Error getting web bindings: " + e.getMessage());
            ie.initCause(e);
            throw ie;
        }
        return instanceBindingsMap;
    }

    private String getInstanceName(Target[] targetList) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        ObjectName targetName = ((ProprietaryTarget)targetList[0]).getObjectName();
        String node = (String)this.getMEJB().getAttribute(targetName, "node");
        String instanceName = (String)this.getMEJB().getAttribute(targetName, "instanceName");
        return node + "/" + instanceName;
    }

    private ApplicationStatus getApplicationStatus(ObjectName oname, boolean verbose) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        ApplicationStatus app = new ApplicationStatus();
        app.setVerbose(verbose);
        app.setObjectName(oname);
        app.setState(this.convertStateToString((Integer)this.getMEJB().getAttribute(oname, "state")));
        if (this.isExpectedJ2EEType(oname, "j2eeApplication") || this.isExpectedJ2EEType(oname, "WebModule")) {
            app.setRoutable((Boolean)this.getMEJB().getAttribute(oname, "ohsRouting"));
        } else {
            app.setRoutable(false);
        }
        if (this.isExpectedJ2EEType(oname, "EJBModule")) {
            String ejbName = oname.getKeyProperty("name");
            app.setAppName(oname.getKeyProperty("J2EEApplication") + ":" + ejbName.substring(1, ejbName.length() - 1));
            app.setModuleName(ejbName.substring(1, ejbName.length() - 1));
            app.setModuleType("EJB");
        } else if (this.isExpectedJ2EEType(oname, "WebModule")) {
            app.setAppName(oname.getKeyProperty("J2EEApplication") + ":" + oname.getKeyProperty("name"));
            String webName = oname.getKeyProperty("name");
            String contextRoot = null;
            contextRoot = verbose ? this.getContextRoot(oname) : null;
            app.setModuleName(webName);
            app.setWebContextRoot(contextRoot);
            app.setModuleType("WEB");
        } else if (this.isExpectedJ2EEType(oname, "ResourceAdapterModule")) {
            app.setAppName(oname.getKeyProperty("J2EEApplication") + ":" + oname.getKeyProperty("name"));
            app.setModuleName(oname.getKeyProperty("name"));
            app.setModuleType("CONNECTOR");
        } else if (this.isExpectedJ2EEType(oname, "AppClientModule")) {
            app.setAppName(oname.getKeyProperty("J2EEApplication") + ":" + oname.getKeyProperty("name"));
            app.setModuleName(oname.getKeyProperty("name"));
            app.setModuleType("APPCLIENT");
        } else {
            app.setAppName(oname.getKeyProperty("name"));
            app.setParent((String)this.getMEJB().getAttribute(oname, "parentApplicationName"));
            app.setModuleType("APPLICATION");
            ObjectName clusterApplication = new ObjectName("*:j2eeType=ClusteredApplication,name=singleton,J2EEApplication=" + app.getAppName() + ",*");
            Set onames = this.getMEJB().queryNames(clusterApplication, null);
            Iterator iter = onames.iterator();
            while (iter.hasNext()) {
                ObjectName name = (ObjectName)iter.next();
                app.setJGroupName((String)this.getMEJB().getAttribute(name, "GroupName"));
                app.setJGroupProtocol((String)this.getMEJB().getAttribute(name, "Protocol"));
            }
        }
        return app;
    }

    private ApplicationStatus getWebBindingStatus(WebBinding binding) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        ApplicationStatus app = new ApplicationStatus();
        app.setAppName(binding.getApplication() + ":" + binding.getWebModule() + ":" + binding.getRootContext() + ":" + binding.getWebSiteName());
        app.setModuleName(binding.getWebModule());
        app.setWebContextRoot(binding.getRootContext());
        app.setWebSite(binding.getWebSiteName());
        app.setPreload(binding.getPreload());
        app.setShared(binding.getPreload());
        app.setAccessLog(binding.getAccessLog());
        app.setMaxInactivityTime(binding.getMaxInactivityTime());
        app.setWebSitePath(binding.getWebSitePath());
        return app;
    }

    private boolean isExpectedJ2EEType(ObjectName oname, String j2eeType) {
        return oname.getKeyProperty("j2eeType").equalsIgnoreCase(j2eeType);
    }

    private String convertStateToString(int state) {
        String status;
        switch (state) {
            case 0: {
                status = "starting";
                break;
            }
            case 1: {
                status = "running";
                break;
            }
            case 2: {
                status = "stopping";
                break;
            }
            case 3: {
                status = "stopped";
                break;
            }
            case 4: {
                status = "failed";
                break;
            }
            default: {
                status = "N/A";
            }
        }
        return status;
    }

    private String getContextRoot(ObjectName oname) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException, MalformedObjectNameException {
        String roots = null;
        String moduleName = oname.getKeyProperty("name");
        String appName = oname.getKeyProperty("J2EEApplication");
        String serverName = oname.getKeyProperty("J2EEServer");
        Set onames = this.getMEJB().queryNames(new ObjectName("*:j2eeType=J2EEServer,name=" + serverName), null);
        Iterator iter = onames.iterator();
        while (iter.hasNext()) {
            ObjectName serverOname = (ObjectName)iter.next();
            String[] sites = (String[])this.getMEJB().getAttribute(serverOname, "j2eeWebSites");
            for (int i = 0; i < sites.length; ++i) {
                WebBinding[] bindings = (WebBinding[])this.getMEJB().getAttribute(new ObjectName(sites[i]), "webApps");
                for (int j = 0; j < bindings.length; ++j) {
                    if (!bindings[j].getApplication().equalsIgnoreCase(appName) || !bindings[j].getWebModule().equalsIgnoreCase(moduleName)) continue;
                    roots = roots == null ? bindings[j].getRootContext() : roots + "," + bindings[j].getRootContext();
                }
            }
        }
        return roots != null ? roots : (String)this.getMEJB().getAttribute(oname, "webURL");
    }
}

