/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.spi.InternalRunner;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.jmx.client.deploy.OperationLifeCycle;
import oracle.oc4j.admin.jmx.client.deploy.UploadFileIterator;
import oracle.oc4j.admin.jmx.shared.EventTypeNotificationFilter;
import oracle.oc4j.admin.jmx.shared.RmiDomain;
import oracle.oc4j.admin.management.mejb.ProprietaryManagement;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class InternalDeployer
extends InternalRunner
implements OperationLifeCycle {
    private static int STATE_BEGIN = 0;
    private static int STATE_CANCELUPLOAD = 1;
    private static int STATE_ENDUPLOAD = 2;
    private SharedModuleType moduleType_ = null;
    private boolean isRedeploy_;
    private boolean isUndeploy_;
    private Integer id_;
    private boolean isCancel_;
    private int state_;
    private ObjectName deployerName_;
    private ObjectName uploaderName_;

    private InternalDeployer(Management mejb, String name, Map extraParameters, Target[] targetList, Object archive, ProgressListener listen, SharedModuleType moduleType, boolean isRedeploy) {
        super(mejb, name, extraParameters, targetList, archive, CommandType.DISTRIBUTE, listen);
        this.moduleType_ = moduleType;
        this.isRedeploy_ = isRedeploy;
        this.isUndeploy_ = false;
        this.init();
    }

    private InternalDeployer(Management mejb, String name, Target[] targetList, ProgressListener listen, SharedModuleType moduleType) {
        super(mejb, name, null, targetList, null, CommandType.UNDEPLOY, listen);
        this.moduleType_ = moduleType;
        this.isUndeploy_ = true;
        this.init();
    }

    private void init() {
        RmiDomain domain = ((ProprietaryManagement)this.mejb_).getDomain();
        this.uploaderName_ = domain.getUploaderName();
        this.deployerName_ = domain.getDeployerName();
        this.setLifeCycleCallBackInterface(this);
        if (!this.isUndeploy_) {
            this.isCancel_ = false;
            this.state_ = STATE_BEGIN;
        }
    }

    public static ProgressObject deploy(Management mejb, String name, Map extraParameters, Target[] targetList, Object archive, ProgressListener listen, SharedModuleType moduleType, boolean isRedeploy) {
        if (targetList == null || targetList.length == 0) {
            throw new IllegalArgumentException("Invalid targetList. Cannot be null or empty.");
        }
        InternalDeployer deployer = new InternalDeployer(mejb, name, extraParameters, targetList, archive, listen, moduleType, isRedeploy);
        deployer.startOperation();
        return deployer.progressObject_;
    }

    public static ProgressObject undeploy(Management mejb, String appName, Target[] targetList, ProgressListener listen, SharedModuleType moduleType) {
        if (targetList == null || targetList.length == 0) {
            throw new IllegalArgumentException("Invalid targetList. Cannot be null or empty.");
        }
        InternalDeployer undeployer = new InternalDeployer(mejb, appName, targetList, listen, moduleType);
        undeployer.startOperation();
        return undeployer.progressObject_;
    }

    public void theRun() {
        if (this.isUndeploy_) {
            this.doUndeploy();
        } else {
            this.doDeploy();
        }
    }

    private void doDeploy() {
        try {
            boolean needUpload = true;
            if (this.archive_ instanceof File) {
                if (((File)this.archive_).isDirectory()) {
                    needUpload = false;
                } else {
                    InetAddress serverHost;
                    InetAddress clientHost = InetAddress.getLocalHost();
                    if (clientHost.equals(serverHost = InetAddress.getByName(((ProprietaryManagement)this.mejb_).getDomain().getHost()))) {
                        needUpload = false;
                    }
                }
            }
            if (needUpload) {
                this.uploadFile();
                if (this.state_ == STATE_CANCELUPLOAD) {
                    return;
                }
            }
            HashSet<String> events = new HashSet<String>();
            events.add("deploy." + this.name_);
            EventTypeNotificationFilter filter = new EventTypeNotificationFilter(events);
            this.mejb_.getListenerRegistry().addNotificationListener(this.deployerName_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
            Object[] params = new Object[]{needUpload ? this.id_ : ((File)this.archive_).getAbsolutePath(), this.name_, this.extraParameters_, this.moduleType_, this.targetJ2eeServers_};
            String[] signature = new String[]{needUpload ? "java.lang.Integer" : "java.lang.String", "java.lang.String", "java.util.Map", "oracle.oc4j.admin.management.shared.SharedModuleType", "[Ljavax.management.ObjectName;"};
            String cmd = this.isRedeploy_ ? "redeploy" : "deploy";
            this.mejb_.invoke(this.deployerName_, cmd, params, signature);
        }
        catch (DeploymentRuntimeException de) {
            throw (DeploymentRuntimeException)de.fillInStackTrace();
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException(e);
        }
    }

    private void doUndeploy() {
        try {
            EventTypeNotificationFilter filter = new EventTypeNotificationFilter("undeploy." + this.name_);
            this.mejb_.getListenerRegistry().addNotificationListener(this.deployerName_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
            Object[] params = new Object[]{this.name_, new Boolean(this.moduleType_.isRar()), this.targetJ2eeServers_};
            String[] signature = new String[]{"java.lang.String", Boolean.TYPE.getName(), "[Ljavax.management.ObjectName;"};
            this.mejb_.invoke(this.deployerName_, "undeploy", params, signature);
        }
        catch (DeploymentRuntimeException de) {
            throw (DeploymentRuntimeException)de.fillInStackTrace();
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException(e);
        }
    }

    private void uploadFile() throws DeploymentRuntimeException {
        UploadFileIterator iterator = null;
        try {
            iterator = this.archive_ instanceof File ? new UploadFileIterator((File)this.archive_) : new UploadFileIterator((InputStream)this.archive_);
            if (!iterator.hasMoreBytes()) {
                throw new DeploymentRuntimeException("Uploaded stream should not be empty!");
            }
            Object[] params = new Object[]{this.name_ + this.moduleType_.getModuleExtention()};
            String[] signature = new String[]{"java.lang.String"};
            this.id_ = (Integer)this.mejb_.invoke(this.uploaderName_, "beginUpload", params, signature);
            EventTypeNotificationFilter filter = new EventTypeNotificationFilter("upload." + this.id_);
            this.mejb_.getListenerRegistry().addNotificationListener(this.uploaderName_, (NotificationListener)this.progressObject_, (NotificationFilter)filter, null);
            while (!this.isCancel_ && iterator.hasMoreBytes()) {
                params = new Object[]{this.id_, iterator.getBytes()};
                signature = new String[]{"java.lang.Integer", "[B"};
                this.mejb_.invoke(this.uploaderName_, "upload", params, signature);
            }
            if (this.isCancel_) {
                this.doCancel(this.uploaderName_);
                this.state_ = STATE_CANCELUPLOAD;
            } else {
                params = new Object[]{this.id_};
                signature = new String[]{"java.lang.Integer"};
                this.mejb_.invoke(this.uploaderName_, "endUpload", params, signature);
                this.state_ = STATE_ENDUPLOAD;
            }
        }
        catch (DeploymentRuntimeException de) {
            throw (DeploymentRuntimeException)de.fillInStackTrace();
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException(e);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public SharedModuleType moduleType() {
        return this.moduleType_;
    }

    public void cancel() {
        if (this.isUndeploy_) {
            throw new DeploymentRuntimeException("cancel() is not supported for undeployment!");
        }
        if (this.state_ == STATE_ENDUPLOAD) {
            this.doCancel(this.deployerName_);
        } else {
            this.isCancel_ = true;
        }
    }

    public void stop() {
        throw new DeploymentRuntimeException("stop() is not supported!");
    }

    private void doCancel(ObjectName name) throws DeploymentRuntimeException {
        Object[] params = new Object[]{this.id_};
        String[] signature = new String[]{"java.lang.Integer"};
        try {
            this.mejb_.invoke(name, "cancel", params, signature);
        }
        catch (Exception e) {
            throw new DeploymentRuntimeException("cancel: " + e.getMessage(), e);
        }
    }
}

