/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import oracle.ias.opmn.optic.OpticException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.cmdline.util.ApplicationStatus;
import oracle.oc4j.admin.deploy.spi.ClusterHelper;
import oracle.oc4j.admin.deploy.spi.ClusterJ2EEWebSiteImpl;
import oracle.oc4j.admin.deploy.spi.ClusterTargetImpl;
import oracle.oc4j.admin.deploy.spi.ClusterTargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.J2EEWebSite;
import oracle.oc4j.admin.deploy.spi.Oc4jDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryClusterDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryClusterTargetModuleID;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.status.ClusterProgressObjectImpl;
import oracle.oc4j.admin.jmx.client.CoreRemoteMBeanServer;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.Oc4jOpmnRmiDomain;
import oracle.oc4j.admin.jmx.shared.RmiDomain;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXClusterRuntimeException;
import oracle.oc4j.admin.management.mejb.MEjbFactory;
import oracle.oc4j.admin.management.shared.ImportSharedLibrary;
import oracle.oc4j.admin.management.shared.SharedLibrary;

public class ClusterDeploymentManager
extends Oc4jDeploymentManager
implements ProprietaryClusterDeploymentManager {
    private static Logger logger_ = TraceLogger.getLogger((Class)ClusterDeploymentManager.class);
    private transient String deployerURI_ = null;
    private transient String username_ = null;
    private transient String pwd_ = null;

    public ClusterDeploymentManager(String deployerURI, String username, String pwd) throws DeploymentManagerCreationException {
        super(ClusterHelper.getLocalClusterDomain(deployerURI, username, pwd, Locale.getDefault()));
        this.deployerURI_ = deployerURI;
        this.username_ = username;
        this.pwd_ = pwd;
        if (logger_.isLoggable(Level.FINE)) {
            logger_.fine("ClusterDeploymentManager.getOC4JComponentClusterName(): " + this.getOC4JComponentClusterName());
            logger_.fine("ClusterDeploymentManager.getValidationASInstance(): " + this.getValidationASInstance());
            logger_.fine("ClusterDeploymentManager.getASInstanceHost(): " + this.getASInstanceHost());
            logger_.fine("ClusterDeploymentManager.getDeployerURI(): " + this.getDeployerURI());
        }
    }

    public Target[] getTargets() throws IllegalStateException {
        try {
            Set configSetUrls = ClusterHelper.getConfigSetDeployerURLs(this.deployerURI_);
            Target[] tgts = new Target[configSetUrls.size()];
            Iterator iter = configSetUrls.iterator();
            int cnt = 0;
            while (iter.hasNext()) {
                String url = (String)iter.next();
                tgts[cnt++] = new ClusterTargetImpl(url, this.username_, this.pwd_, this.getCurrentLocale());
            }
            return tgts;
        }
        catch (OpticException oe) {
            IllegalStateException ile = new IllegalStateException(oe.getMessage());
            ile.initCause(oe);
            throw ile;
        }
    }

    public final ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.distribute(targetList, moduleArchive, deploymentPlan, listen);
    }

    public final ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.distribute(targetList, moduleArchive, deploymentPlan, listen);
    }

    public final ProgressObject distribute(Target[] targetList, File moduleArchive, InputStream deploymentPlan) throws IllegalStateException {
        ProgressListener listen = null;
        return this.distribute(targetList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject distribute(Target[] targetList, InputStream moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws IllegalStateException {
        byte[] archive = this.geyBytesFromStream(moduleArchive);
        byte[] plan = this.geyBytesFromStream(deploymentPlan);
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.DISTRIBUTE, targetList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).distribute(configSetTargets, new ByteArrayInputStream(archive), new ByteArrayInputStream(plan));
                progObj.addConfigSet(configSetDepMan, targetList[i], configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + targetList[i], t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(targetList[i], t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, File deploymentPlan, ProgressListener listen) throws IllegalStateException {
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.DISTRIBUTE, targetList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).distribute(configSetTargets, moduleArchive, deploymentPlan);
                progObj.addConfigSet(configSetDepMan, targetList[i], configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + targetList[i], t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(targetList[i], t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject distribute(Target[] targetList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws IllegalStateException {
        byte[] plan = this.geyBytesFromStream(deploymentPlan);
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.DISTRIBUTE, targetList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).distribute(configSetTargets, moduleArchive, new ByteArrayInputStream(plan));
                progObj.addConfigSet(configSetDepMan, targetList[i], configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + targetList[i], t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(targetList[i], t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject start(TargetModuleID[] moduleIDList, ProgressListener listen) throws IllegalStateException {
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.START, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            DeploymentManager configSetDepMan = tgt.getDeploymentManager();
            Target[] configSetTargets = configSetDepMan.getTargets();
            TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
            ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).start(confSetTargetModuleID);
            progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
        }
        return progObj;
    }

    public ProgressObject stop(TargetModuleID[] moduleIDList, ProgressListener listen, Map params) throws IllegalStateException {
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.STOP, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            DeploymentManager configSetDepMan = tgt.getDeploymentManager();
            Target[] configSetTargets = configSetDepMan.getTargets();
            TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
            ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).stop(confSetTargetModuleID);
            progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
        }
        return progObj;
    }

    public ProgressObject undeploy(TargetModuleID[] moduleIDList, ProgressListener listen) throws IllegalStateException {
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.UNDEPLOY, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).undeploy(confSetTargetModuleID);
                progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + tgt, t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(tgt, t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, File deploymentPlan, ProgressListener listen, boolean keepSettings) throws UnsupportedOperationException, IllegalStateException {
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.REDEPLOY, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).redeploy(confSetTargetModuleID, moduleArchive, deploymentPlan, null, keepSettings);
                progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + tgt, t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(tgt, t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, listen, false);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, File moduleArchive, InputStream deploymentPlan, ProgressListener listen, boolean keepSettings) throws UnsupportedOperationException, IllegalStateException {
        byte[] plan = this.geyBytesFromStream(deploymentPlan);
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.REDEPLOY, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).redeploy(confSetTargetModuleID, moduleArchive, new ByteArrayInputStream(plan), null, keepSettings);
                progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + tgt, t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(tgt, t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan) throws UnsupportedOperationException, IllegalStateException {
        ProgressListener listen = null;
        return this.redeploy(moduleIDList, moduleArchive, deploymentPlan, listen);
    }

    public ProgressObject redeploy(TargetModuleID[] moduleIDList, InputStream moduleArchive, InputStream deploymentPlan, ProgressListener listen) throws UnsupportedOperationException, IllegalStateException {
        byte[] archive = this.geyBytesFromStream(moduleArchive);
        byte[] plan = this.geyBytesFromStream(deploymentPlan);
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.REDEPLOY, moduleIDList.length);
        if (listen != null) {
            progObj.addProgressListener(listen);
        }
        for (int i = 0; i < moduleIDList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
            try {
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                TargetModuleID[] confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).redeploy(confSetTargetModuleID, new ByteArrayInputStream(archive), new ByteArrayInputStream(plan));
                progObj.addConfigSet(configSetDepMan, (ClusterTargetImpl)moduleIDList[i].getTarget(), configSetProgObj);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Cannot get connection for Target: " + tgt, t);
                }
                progObj.addConfigSetForWhichConnectionCanNotBeObtained(tgt, t.getMessage());
            }
        }
        return progObj;
    }

    public ProgressObject install(String name, Target[] targetList, Object input, ObjectName mbean, String operation, Object[] params, String[] sigs, ProgressListener listener) {
        byte[] content = null;
        if (input instanceof InputStream) {
            content = this.geyBytesFromStream((InputStream)input);
        }
        ClusterProgressObjectImpl progObj = new ClusterProgressObjectImpl(CommandType.DISTRIBUTE, targetList.length);
        if (listener != null) {
            progObj.addProgressListener(listener);
        }
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            DeploymentManager configSetDepMan = tgt.getDeploymentManager();
            Target[] configSetTargets = configSetDepMan.getTargets();
            Object data = input;
            if (content != null) {
                data = new ByteArrayInputStream(content);
            }
            ProgressObject configSetProgObj = ((ProprietaryConnectedDeploymentManager)configSetDepMan).install(name, configSetTargets, data, mbean, operation, params, sigs, null);
            progObj.addConfigSet(configSetDepMan, targetList[i], configSetProgObj);
        }
        return progObj;
    }

    public void bindWebApp(TargetModuleID moduleID, String siteName) {
        this.bindWebApp(moduleID, siteName, (HashMap)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindWebApp(TargetModuleID moduleID, String siteName, HashMap optionalParams) {
        ClusterTargetImpl tgt = (ClusterTargetImpl)((ProprietaryTargetModuleID)moduleID).getTarget();
        ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
        TargetModuleID tid = ((ProprietaryClusterTargetModuleID)moduleID).getInstanceTargetModuleID();
        try {
            configSetDepMan.bindWebApp(tid, siteName, optionalParams);
        }
        finally {
            if (configSetDepMan != null) {
                configSetDepMan.release();
            }
        }
    }

    public void bindWebApp(TargetModuleID moduleID, String siteName, String contextRoot) {
        this.bindWebApp(moduleID, siteName, contextRoot, (HashMap)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindWebApp(TargetModuleID moduleID, String siteName, String contextRoot, HashMap optionalParams) {
        ClusterTargetImpl tgt = (ClusterTargetImpl)((ProprietaryTargetModuleID)moduleID).getTarget();
        ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
        TargetModuleID tid = ((ProprietaryClusterTargetModuleID)moduleID).getInstanceTargetModuleID();
        try {
            configSetDepMan.bindWebApp(tid, siteName, contextRoot, optionalParams);
        }
        finally {
            if (configSetDepMan != null) {
                configSetDepMan.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindWebApp(TargetModuleID moduleID, String siteName) {
        ClusterTargetImpl tgt = (ClusterTargetImpl)((ProprietaryTargetModuleID)moduleID).getTarget();
        ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
        TargetModuleID tid = ((ProprietaryClusterTargetModuleID)moduleID).getInstanceTargetModuleID();
        try {
            configSetDepMan.unbindWebApp(tid, siteName);
        }
        finally {
            if (configSetDepMan != null) {
                configSetDepMan.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J2EEWebSite[] getJ2EEWebSites(Target target) {
        if (!(target instanceof ClusterTargetImpl)) {
            throw new IllegalArgumentException("Invalid Target Type: " + target);
        }
        ClusterTargetImpl tgt = (ClusterTargetImpl)target;
        ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
        try {
            Target[] confSetTarget = configSetDepMan.getTargets();
            J2EEWebSite[] res = configSetDepMan.getJ2EEWebSites(confSetTarget[0]);
            for (int i = 0; i < res.length; ++i) {
                res[i] = new ClusterJ2EEWebSiteImpl(res[i]);
            }
            J2EEWebSite[] j2EEWebSiteArray = res;
            return j2EEWebSiteArray;
        }
        finally {
            configSetDepMan.release();
        }
    }

    public TargetModuleID getTargetModuleIDForApplication(String name, Target target) {
        if (name == null) {
            return null;
        }
        String pattn = "*:j2eeType=J2EEApplication,name=" + name + ",J2EEServer=";
        return this.getTargetModuleIDForPattern(pattn, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID getTargetModuleIDForPattern(String pattn, Target target) {
        if (!(target instanceof ClusterTargetImpl)) {
            throw new IllegalArgumentException("Invalid Target Type: " + target);
        }
        ClusterTargetImpl tgt = (ClusterTargetImpl)target;
        ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
        try {
            ClusterTargetModuleIDImpl res;
            Target[] confSetTarget = configSetDepMan.getTargets();
            TargetModuleID tgtid = configSetDepMan.getTargetModuleIDForPattern(pattn, confSetTarget[0]);
            if (tgtid == null) {
                TargetModuleID targetModuleID = null;
                return targetModuleID;
            }
            ClusterTargetModuleIDImpl clusterTargetModuleIDImpl = res = new ClusterTargetModuleIDImpl(tgt, ((ProprietaryTargetModuleID)tgtid).getObjectName());
            return clusterTargetModuleIDImpl;
        }
        finally {
            configSetDepMan.release();
        }
    }

    public TargetModuleID[] getTargetModuleIDsForApplication(String name, Target[] targets) {
        if (name == null) {
            return null;
        }
        String pattn = "*:j2eeType=J2EEApplication,name=" + name + ",J2EEServer=";
        return this.getTargetModuleIDsForPattern(pattn, targets);
    }

    public TargetModuleID[] getTargetModuleIDsForPattern(String pattn, Target[] targets) {
        ArrayList<TargetModuleID> res = new ArrayList<TargetModuleID>();
        for (int i = 0; i < targets.length; ++i) {
            TargetModuleID tgid = this.getTargetModuleIDForPattern(pattn, targets[i]);
            if (tgid == null) continue;
            res.add(tgid);
        }
        TargetModuleID[] tgids = new TargetModuleID[res.size()];
        Iterator it = res.iterator();
        int c = 0;
        while (it.hasNext()) {
            tgids[c++] = (TargetModuleID)it.next();
        }
        return tgids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        ArrayList<ClusterTargetModuleIDImpl> res = new ArrayList<ClusterTargetModuleIDImpl>();
        for (int i = 0; i < targetList.length; ++i) {
            if (!(targetList[i] instanceof ClusterTargetImpl)) {
                throw new IllegalArgumentException("Invalid Target Type: " + targetList[i]);
            }
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
            try {
                Target[] confSetTarget = configSetDepMan.getTargets();
                TargetModuleID[] tgtids = configSetDepMan.getRunningModules(moduleType, confSetTarget);
                for (int j = 0; j < tgtids.length; ++j) {
                    res.add(new ClusterTargetModuleIDImpl(tgt, ((ProprietaryTargetModuleID)tgtids[j]).getObjectName()));
                }
                continue;
            }
            finally {
                configSetDepMan.release();
            }
        }
        TargetModuleID[] targetModuleIDs = new TargetModuleID[res.size()];
        Iterator it = res.iterator();
        int tgtIDCnt = 0;
        while (it.hasNext()) {
            targetModuleIDs[tgtIDCnt++] = (TargetModuleID)it.next();
        }
        return targetModuleIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        ArrayList<ClusterTargetModuleIDImpl> res = new ArrayList<ClusterTargetModuleIDImpl>();
        for (int i = 0; i < targetList.length; ++i) {
            if (!(targetList[i] instanceof ClusterTargetImpl)) {
                throw new IllegalArgumentException("Invalid Target Type: " + targetList[i]);
            }
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
            try {
                Target[] confSetTarget = configSetDepMan.getTargets();
                TargetModuleID[] tgtids = configSetDepMan.getNonRunningModules(moduleType, confSetTarget);
                for (int j = 0; j < tgtids.length; ++j) {
                    res.add(new ClusterTargetModuleIDImpl(tgt, ((ProprietaryTargetModuleID)tgtids[j]).getObjectName()));
                }
                continue;
            }
            finally {
                configSetDepMan.release();
            }
        }
        TargetModuleID[] targetModuleIDs = new TargetModuleID[res.size()];
        Iterator it = res.iterator();
        int tgtIDCnt = 0;
        while (it.hasNext()) {
            targetModuleIDs[tgtIDCnt++] = (TargetModuleID)it.next();
        }
        return targetModuleIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        ArrayList<ClusterTargetModuleIDImpl> res = new ArrayList<ClusterTargetModuleIDImpl>();
        for (int i = 0; i < targetList.length; ++i) {
            if (!(targetList[i] instanceof ClusterTargetImpl)) {
                throw new IllegalArgumentException("Invalid Target Type: " + targetList[i]);
            }
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
            try {
                Target[] confSetTarget = configSetDepMan.getTargets();
                TargetModuleID[] tgtids = configSetDepMan.getAvailableModules(moduleType, confSetTarget);
                for (int j = 0; j < tgtids.length; ++j) {
                    res.add(new ClusterTargetModuleIDImpl(tgt, ((ProprietaryTargetModuleID)tgtids[j]).getObjectName()));
                }
                continue;
            }
            finally {
                configSetDepMan.release();
            }
        }
        TargetModuleID[] targetModuleIDs = new TargetModuleID[res.size()];
        Iterator it = res.iterator();
        int tgtIDCnt = 0;
        while (it.hasNext()) {
            targetModuleIDs[tgtIDCnt++] = (TargetModuleID)it.next();
        }
        return targetModuleIDs;
    }

    private byte[] geyBytesFromStream(InputStream in) {
        try {
            byte[] res = new byte[in.available()];
            in.read(res);
            return res;
        }
        catch (IOException ioe) {
            RuntimeException re = new RuntimeException(ioe.getMessage());
            re.initCause(ioe);
            throw re;
        }
    }

    public String getOC4JComponentClusterName() {
        return this.getValidationDomain().getOC4JComponentClusterName();
    }

    public String getValidationASInstance() {
        return this.getValidationDomain().getIASInstance();
    }

    public String getASInstanceHost() {
        return this.getValidationDomain().getHost();
    }

    public String getDeployerURI() {
        return this.deployerURI_;
    }

    private Oc4jOpmnRmiDomain getValidationDomain() {
        CoreRemoteMBeanServer mejb = (CoreRemoteMBeanServer)this.getMEJB();
        Oc4jOpmnRmiDomain domain = (Oc4jOpmnRmiDomain)mejb.getDomain();
        return domain;
    }

    public Target getValidationTarget() throws IllegalStateException {
        Map uriComps = ClusterHelper.getDeployerURIComponents(this.getDeployerURI());
        String validationTargetUrl = "deployer:oc4j:opmn://" + uriComps.get("host") + ":" + uriComps.get("port") + "/" + this.getValidationASInstance() + "/" + this.getOC4JComponentClusterName();
        ClusterTargetImpl tgt = new ClusterTargetImpl(validationTargetUrl, this.username_, this.pwd_, this.getCurrentLocale());
        return tgt;
    }

    public boolean modifySharedLibrary(Target[] targetList, String libraryName, String libraryVersion, Boolean libraryCompatible, File[] installCodeSources, String[] addCodeSources, String[] removeCodeSources, ImportSharedLibrary[] addImports, String[] removeImports) throws InstantiationException {
        boolean ret = true;
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                boolean tmp = configSetDepMan.modifySharedLibrary(configSetTargets, libraryName, libraryVersion, libraryCompatible, installCodeSources, addCodeSources, removeCodeSources, addImports, removeImports);
                if (tmp) continue;
                ret = false;
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error modifying shared library in : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error modifying shared library in group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return ret;
    }

    public void publishSharedLibrary(Target[] targetList, String name, String version, String parentName, String parentVersion, Boolean libraryCompatible, File[] installCodeSources, String[] addCodeSources, ImportSharedLibrary[] imports) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.publishSharedLibrary(configSetTargets, name, version, parentName, parentVersion, libraryCompatible, installCodeSources, addCodeSources, imports);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error publishing shared library to : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error publishing shared library to group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void addImportSharedLibrary(TargetModuleID[] moduleIDList, String name, String minVersion, String maxVersion) throws InstantiationException {
        TargetModuleID[] confSetTargetModuleID = null;
        InstantiationException instExc = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            try {
                ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ((ProprietaryConnectedDeploymentManager)configSetDepMan).addImportSharedLibrary(confSetTargetModuleID, name, minVersion, maxVersion);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error importing a shared library for an application : " + moduleIDList[i], t);
                }
                instExc = new InstantiationException(t.getMessage());
                instExc.initCause(t);
                if (instExc == null) continue;
                throw instExc;
            }
        }
    }

    public void addRemoveInheritedSharedLibrary(TargetModuleID[] moduleIDList, String name) throws InstantiationException {
        TargetModuleID[] confSetTargetModuleID = null;
        InstantiationException instExc = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            try {
                ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ((ProprietaryConnectedDeploymentManager)configSetDepMan).addRemoveInheritedSharedLibrary(confSetTargetModuleID, name);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error adding a <remove-inherited> element to an application : " + moduleIDList[i], t);
                }
                instExc = new InstantiationException(t.getMessage());
                instExc.initCause(t);
                if (instExc == null) continue;
                throw instExc;
            }
        }
    }

    public void deleteRemoveInheritedSharedLibrary(TargetModuleID[] moduleIDList, String name) throws InstantiationException {
        TargetModuleID[] confSetTargetModuleID = null;
        InstantiationException instExc = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            try {
                ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ((ProprietaryConnectedDeploymentManager)configSetDepMan).deleteRemoveInheritedSharedLibrary(confSetTargetModuleID, name);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error deleting a <remove-inherited> element from an application : " + moduleIDList[i], t);
                }
                instExc = new InstantiationException(t.getMessage());
                instExc.initCause(t);
                if (instExc == null) continue;
                throw instExc;
            }
        }
    }

    public void deleteImportSharedLibrary(TargetModuleID[] moduleIDList, String name) throws InstantiationException {
        TargetModuleID[] confSetTargetModuleID = null;
        InstantiationException instExc = null;
        for (int i = 0; i < moduleIDList.length; ++i) {
            try {
                ClusterTargetImpl tgt = (ClusterTargetImpl)moduleIDList[i].getTarget();
                DeploymentManager configSetDepMan = tgt.getDeploymentManager();
                confSetTargetModuleID = new TargetModuleID[]{moduleIDList[i]};
                ((ProprietaryConnectedDeploymentManager)configSetDepMan).deleteImportSharedLibrary(confSetTargetModuleID, name);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error deleting an imported shared library from an application : " + moduleIDList[i], t);
                }
                instExc = new InstantiationException(t.getMessage());
                instExc.initCause(t);
                if (instExc == null) continue;
                throw instExc;
            }
        }
    }

    public SharedLibrary[] getSharedLibraries(Target[] targetList) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        Vector<SharedLibrary> libs = new Vector<SharedLibrary>();
        Vector<SharedLibrary> tmp = new Vector<SharedLibrary>();
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                SharedLibrary[] libArray = configSetDepMan.getSharedLibraries(configSetTargets);
                for (int j = 0; j < libArray.length; ++j) {
                    if (i == 0) {
                        libs.add(libArray[j]);
                        continue;
                    }
                    if (!libs.contains(libArray[j])) continue;
                    tmp.add(libArray[j]);
                }
                if (i == 0) continue;
                libs.clear();
                Vector<SharedLibrary> v = libs;
                libs = tmp;
                tmp = v;
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting shared library info from : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting shared library info from group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return libs.toArray(new SharedLibrary[libs.size()]);
    }

    public void removeSharedLibrary(Target[] targetList, String name, String version) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeSharedLibrary(configSetTargets, name, version);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing shared library on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing shared library from group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void createJDBCConnectionPool(Target[] targetList, String applicationName, String name, String factoryClass, String user, String password, String url, List properties) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.createJDBCConnectionPool(configSetTargets, applicationName, name, factoryClass, user, password, url, properties);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error creating JDBC Connection Pool on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error creating JDBC Connection Pool on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void removeDataSourceConnectionPool(Target[] targetList, String applicationName, String name) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeDataSourceConnectionPool(configSetTargets, applicationName, name);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing datasource connection pool on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing datasource connection pool on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void createManagedDataSource(Target[] targetList, String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String connectionPoolName, String txLevel, String dbSchema, Boolean manageLocalTransactions) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.createManagedDataSource(configSetTargets, applicationName, dataSourceName, user, password, jndiLocation, loginTimeout, connectionPoolName, txLevel, dbSchema, manageLocalTransactions);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error creating managed datasource on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error creating managed datasource on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void removeManagedDataSource(Target[] targetList, String applicationName, String dataSourceName) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeManagedDataSource(configSetTargets, applicationName, dataSourceName);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing managed datasource on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing managed datasource on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void createNativeDataSource(Target[] targetList, String applicationName, String dataSourceName, String user, String password, String jndiLocation, Integer loginTimeout, String dataSourceClass, String url, Map properties) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.createNativeDataSource(configSetTargets, applicationName, dataSourceName, user, password, jndiLocation, loginTimeout, dataSourceClass, url, properties);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error creating native datasource on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error creating native datasource on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void removeNativeDataSource(Target[] targetList, String applicationName, String dataSourceName) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeNativeDataSource(configSetTargets, applicationName, dataSourceName);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing native datasource on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing native datasource on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public String getDataSourcesDescriptor(Target[] targetList, String applicationName) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.getDataSourcesDescriptor(configSetTargets, applicationName);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting datasource descriptor on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting datasource descriptor on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public String listDataSources(Target[] targetList, String applicationName) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.listDataSources(configSetTargets, applicationName);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error listing data sources on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error listing data sources on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public String listDataSourceConnectionPools(Target[] targetList, String applicationName) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.listDataSourceConnectionPools(configSetTargets, applicationName);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error listing data source connection pools on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error listing data source connection pools on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public String testDatabaseConnection(Target[] targetList, String applicationName, String sqlStatement, String factoryClass, String user, String password, String url) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.testDatabaseConnection(configSetTargets, applicationName, sqlStatement, factoryClass, user, password, url);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error testing database connection on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error testing database connection on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public String testDataSource(Target[] targetList, String applicationName, String datasourceName, String sqlStatement, String user, String password) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.testDataSource(configSetTargets, applicationName, datasourceName, sqlStatement, user, password);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error testing datasource on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error testing datasource on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public String testConnectionPool(Target[] targetList, String applicationName, String connectionPoolName, String sqlStatement, String user, String password) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        String results = null;
        results = results + "\n________________________________________________";
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                results = results + "\n" + configSetDepMan.testConnectionPool(configSetTargets, applicationName, connectionPoolName, sqlStatement, user, password);
                results = results + "\n________________________________________________";
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error testing connection pool on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error testing connection pool on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return results;
    }

    public void addFactory(Target[] targetList, String domain, String location, String host, String port, String username, String password, String clientID, Boolean isXA) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.addFactory(configSetTargets, domain, location, host, port, username, password, clientID, isXA);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error adding JMS factory on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error adding JMS factory on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void removeFactory(Target[] targetList, String location) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeFactory(configSetTargets, location);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing JMS factory on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing JMS factory on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public List getConnectionFactories(Target[] targetList) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        ArrayList<List> resultsList = new ArrayList<List>();
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                resultsList.add(configSetDepMan.getConnectionFactories(configSetTargets));
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting destinations on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting destinations on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return resultsList;
    }

    public void addDestination(Target[] targetList, String domain, String name, String location, String persistenceFile, String description) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.addDestination(configSetTargets, domain, name, location, persistenceFile, description);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error adding destination on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error adding destination on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void removeDestination(Target[] targetList, String name, Boolean force, Boolean removePFile) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.removeDestination(configSetTargets, name, force, removePFile);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error removing destination on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error removing destination on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public List getDestinations(Target[] targetList) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        ArrayList<List> resultsList = new ArrayList<List>();
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                resultsList.add(configSetDepMan.getDestinations(configSetTargets));
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting destinations on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting destinations on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return resultsList;
    }

    public void restart(Target[] targetList) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.restart(configSetTargets);
                this.invokeSyncDomains((CoreRemoteMBeanServer)configSetDepMan.getMEJB(), ((ProprietaryTarget)targetList[i]).getObjectName(), "start", new Object[0], new String[0]);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error restarting J2EEServer on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error restarting J2EEServer on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    public void shutdown(Target[] targetList) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                configSetDepMan.shutdown(configSetTargets);
                this.invokeSyncDomains((CoreRemoteMBeanServer)configSetDepMan.getMEJB(), ((ProprietaryTarget)targetList[i]).getObjectName(), "stop", new Object[0], new String[0]);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error shutting down J2EEServer on : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error shutting down J2EEServer on group.");
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
    }

    /*
     * Loose catch block
     */
    private void invokeSyncDomains(CoreRemoteMBeanServer mejbServer, ObjectName name, String operationName, Object[] params, String[] signature) throws JMXClusterRuntimeException {
        Domain[] syncDoms;
        RmiDomain domain = mejbServer.getDomain();
        Domain[] domainArray = syncDoms = domain instanceof ClusterDomain ? ((ClusterDomain)((Object)domain)).getSynchronizationDomains(mejbServer.portInUse()) : null;
        if (syncDoms != null) {
            for (int i = 0; i < syncDoms.length; ++i) {
                Management mejbSync = null;
                mejbSync = MEjbFactory.getManagement(syncDoms[i]);
                mejbSync.invoke(name, operationName, params, signature);
                Object var12_10 = null;
                if (mejbSync == null) continue;
                try {
                    mejbSync.remove();
                }
                catch (Throwable te) {
                    if (!logger_.isLoggable(Level.FINE)) continue;
                    logger_.log(Level.FINE, te.getMessage(), te);
                }
                continue;
                {
                    catch (Exception t) {
                        if (logger_.isLoggable(Level.SEVERE)) {
                            logger_.log(Level.SEVERE, t.getMessage(), t);
                        }
                        throw new JMXClusterRuntimeException(t.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    block11: {
                        var12_10 = null;
                        if (mejbSync != null) {
                            try {
                                mejbSync.remove();
                            }
                            catch (Throwable te) {
                                if (!logger_.isLoggable(Level.FINE)) break block11;
                                logger_.log(Level.FINE, te.getMessage(), te);
                            }
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public Map getApplications(Target[] targetList, boolean verbose) throws InstantiationException {
        JMXClusterRuntimeException cre = null;
        HashMap clusterAppMap = new HashMap();
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                Map instanceAppMap = configSetDepMan.getApplications(configSetTargets, verbose);
                Vector<ApplicationStatus> clusterApplicationStatusVector = new Vector<ApplicationStatus>();
                Iterator instanceAppMapIter = instanceAppMap.entrySet().iterator();
                while (instanceAppMapIter.hasNext()) {
                    Map.Entry entry = instanceAppMapIter.next();
                    Vector applicationStatusVector = (Vector)entry.getValue();
                    for (int vectorIndex = 0; vectorIndex < applicationStatusVector.size(); ++vectorIndex) {
                        ApplicationStatus status = (ApplicationStatus)applicationStatusVector.get(vectorIndex);
                        clusterApplicationStatusVector.add(status);
                    }
                }
                clusterAppMap.put(this.getTargetName(tgt.getName()), clusterApplicationStatusVector);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting application info from : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting application info from group. " + t.getMessage());
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return clusterAppMap;
    }

    public Map getWebBindings(Target[] targetList, String siteName, boolean verbose) throws InstantiationException {
        HashMap clusterBindingsMap = new HashMap();
        JMXClusterRuntimeException cre = null;
        for (int i = 0; i < targetList.length; ++i) {
            ClusterTargetImpl tgt = (ClusterTargetImpl)targetList[i];
            ProprietaryConnectedDeploymentManager configSetDepMan = null;
            try {
                configSetDepMan = (ProprietaryConnectedDeploymentManager)tgt.getDeploymentManager();
                Target[] configSetTargets = configSetDepMan.getTargets();
                Map instanceBindingMap = new HashMap();
                try {
                    instanceBindingMap = configSetDepMan.getWebBindings(configSetTargets, siteName, verbose);
                }
                catch (InstantiationException ie) {
                    if (ie.getCause() instanceof InstanceNotFoundException && ie.getCause().getMessage().startsWith("Unable to find web site")) {
                        clusterBindingsMap.put(this.getTargetName(tgt.getName()), null);
                        continue;
                    }
                    throw ie;
                }
                Vector<ApplicationStatus> clusterApplicationStatusVector = new Vector<ApplicationStatus>();
                Iterator instanceAppMapIter = instanceBindingMap.entrySet().iterator();
                while (instanceAppMapIter.hasNext()) {
                    Map.Entry entry = instanceAppMapIter.next();
                    Vector applicationStatusVector = (Vector)entry.getValue();
                    for (int vectorIndex = 0; vectorIndex < applicationStatusVector.size(); ++vectorIndex) {
                        ApplicationStatus status = (ApplicationStatus)applicationStatusVector.get(vectorIndex);
                        clusterApplicationStatusVector.add(status);
                    }
                }
                clusterBindingsMap.put(this.getTargetName(tgt.getName()), clusterApplicationStatusVector);
                continue;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.WARNING)) {
                    logger_.log(Level.WARNING, "Error getting web binding info from : " + targetList[i], t);
                }
                if (cre == null) {
                    cre = new JMXClusterRuntimeException("Error getting web binding info from group. " + t.getMessage());
                }
                ProprietaryTarget pt = (ProprietaryTarget)configSetDepMan.getTargets()[0];
                cre.addCause(pt.getObjectName(), t);
            }
        }
        if (cre != null) {
            throw cre;
        }
        return clusterBindingsMap;
    }

    private String getTargetName(String longName) {
        int lastIndexoOf = longName.lastIndexOf("/");
        String tmpName = longName.substring(0, lastIndexoOf);
        int nextIndexOf = tmpName.lastIndexOf("/");
        return longName.substring(nextIndexOf + 1, longName.length());
    }
}

