/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.shared.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.enterprise.deploy.model.DeployableObject;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.StringUtils;
import oracle.oc4j.admin.deploy.spi.xml.StringTypeBase;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static Node getChild(Node parent, String childName) {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals(childName)) continue;
                return node;
            }
        }
        return null;
    }

    public static String getValue(Node parent, String childName) {
        Node node = XMLUtils.getChild(parent, childName);
        return node == null ? null : XMLUtils.getValue(node);
    }

    public static String getValue(Node node) {
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String value = child.getNodeValue();
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static String[] getAttributeNames(Node node) {
        NamedNodeMap nodeMap = ((XMLElement)node).getAttributes();
        if (nodeMap == null) {
            return null;
        }
        Vector<String> ret = new Vector<String>();
        int lng = nodeMap.getLength();
        for (int n = 0; n < lng; ++n) {
            ret.add(nodeMap.item(n).getNodeName());
        }
        return ret.toArray(new String[0]);
    }

    public static String getAttribute(Node node, String attrName) {
        String value = ((XMLElement)node).getAttribute(attrName);
        if (value == null) {
            return "";
        }
        return value.trim();
    }

    public static String encode(String str) {
        if (str == null) {
            return "";
        }
        if (str.indexOf(38) >= 0) {
            str = StringUtils.replace(str, '&', "&amp;");
        }
        if (str.indexOf(60) >= 0) {
            str = StringUtils.replace(str, '<', "&lt;");
        }
        if (str.indexOf(62) >= 0) {
            str = StringUtils.replace(str, '>', "&gt;");
        }
        if (str.indexOf(34) >= 0) {
            str = StringUtils.replace(str, '\"', "&quot;");
        }
        return str;
    }

    public static boolean isValidIcon(String icon) {
        if (icon == null) {
            return true;
        }
        int pos = icon.lastIndexOf(46);
        if (pos <= 0) {
            return false;
        }
        String suffix = icon.substring(pos + 1);
        return suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("gif");
    }

    public static URL createURL(String fileName) throws ExtendedRuntimeException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                throw new ExtendedRuntimeException(e);
            }
        }
        return url;
    }

    public static XMLDocument parse(URL url, boolean validationMode) throws ExtendedRuntimeException {
        DOMParser parser = new DOMParser();
        if (validationMode) {
            parser.setValidationMode(2);
        } else {
            parser.setValidationMode(0);
            parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        }
        parser.showWarnings(true);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            parser.setErrorStream((OutputStream)byteArray);
            parser.parse(url);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            try {
                byteArray.close();
                msg = byteArray.toString();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw new ExtendedRuntimeException(msg, t);
        }
        return parser.getDocument();
    }

    public static XMLDocument parse(InputStream inputStream, boolean validationMode) throws ExtendedRuntimeException {
        DOMParser parser = new DOMParser();
        if (validationMode) {
            parser.setValidationMode(2);
        } else {
            parser.setValidationMode(0);
            parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        }
        parser.showWarnings(true);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            parser.setErrorStream((OutputStream)byteArray);
            parser.parse(inputStream);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            try {
                byteArray.close();
                msg = byteArray.toString();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw new ExtendedRuntimeException(msg, t);
        }
        return parser.getDocument();
    }

    public static XMLDocument parse(BufferedReader reader, boolean validationMode) throws ExtendedRuntimeException {
        DOMParser parser = new DOMParser();
        if (validationMode) {
            parser.setValidationMode(2);
        } else {
            parser.setValidationMode(0);
            parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
        }
        parser.showWarnings(true);
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        try {
            parser.setErrorStream((OutputStream)byteArray);
            parser.parse((Reader)reader);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            try {
                byteArray.close();
                msg = byteArray.toString();
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            throw new ExtendedRuntimeException(msg, t);
        }
        return parser.getDocument();
    }

    public static XMLDocument parse(DeployableObject deployableObject, String entry, boolean validationMode) throws ExtendedRuntimeException {
        XMLDocument doc = null;
        InputStream strm = deployableObject.getEntry(entry);
        if (strm != null) {
            doc = XMLUtils.parse(strm, false);
        }
        return doc;
    }

    public static XMLDocument parse(String uri, J2eeFile deployableObject, String entry, boolean validationMode) throws ExtendedRuntimeException {
        XMLDocument doc = null;
        InputStream strm = deployableObject.getEntry(uri, entry);
        if (strm != null) {
            doc = XMLUtils.parse(strm, false);
        }
        return doc;
    }

    public static XMLDocument parse(String content, boolean validationMode) throws ExtendedRuntimeException {
        XMLDocument doc = null;
        try {
            doc = XMLUtils.parse(new BufferedReader(new StringReader(content)), false);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        return doc;
    }

    public static void writeTagAttributeStart(PrintWriter out, String indentation, String tag) throws ExtendedRuntimeException {
        try {
            out.print(indentation + "<" + tag);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTagAttributeEnd(PrintWriter out, String indentation, String tag) throws ExtendedRuntimeException {
        try {
            out.println(">");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTagStart(PrintWriter out, String indentation, String tag) throws ExtendedRuntimeException {
        try {
            out.println(indentation + "<" + tag + ">");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTagValue(PrintWriter out, String indentation, String value) throws ExtendedRuntimeException {
        try {
            value = value != null ? XMLUtils.encode(value) : "";
            out.println(value);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTagEnd(PrintWriter out, String indentation, String tag) throws ExtendedRuntimeException {
        try {
            out.println(indentation + "</" + tag + ">");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTag(PrintWriter out, String indentation, String tag, String value) throws ExtendedRuntimeException {
        try {
            if (value == null) {
                value = "";
            }
            value = XMLUtils.encode(value);
            out.println(indentation + "<" + tag + ">" + value + "</" + tag + ">");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTag(PrintWriter out, String indentation, String tag, StringTypeBase value) throws ExtendedRuntimeException {
        try {
            String v = null;
            if (value != null) {
                v = XMLUtils.encode(value.getValue());
            }
            if (v == null) {
                v = "";
            }
            XMLUtils.writeTag(out, indentation, tag, v);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTag(PrintWriter out, String indentation, String tag, StringTypeBase[] values) throws ExtendedRuntimeException {
        try {
            String v = null;
            if (values != null) {
                for (int n = 0; n < values.length; ++n) {
                    if (values[n] != null) {
                        v = XMLUtils.encode(values[n].getValue());
                    }
                    if (v == null) {
                        v = "";
                    }
                    XMLUtils.writeTag(out, indentation, tag, v);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeTagWithValue(PrintWriter out, String indentation, String tag, String value) throws ExtendedRuntimeException {
        try {
            if (value != null && !value.trim().equals("")) {
                value = XMLUtils.encode(value);
                out.println(indentation + "<" + tag + ">" + value + "</" + tag + ">");
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttribute(PrintWriter out, String indentation, String attribute, boolean value) throws ExtendedRuntimeException {
        try {
            out.print(" " + attribute + "=\"" + value + "\"");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttribute(PrintWriter out, String indentation, String attribute, int value) throws ExtendedRuntimeException {
        try {
            out.print(" " + attribute + "=\"" + value + "\"");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttribute(PrintWriter out, String indentation, String attribute, long value) throws ExtendedRuntimeException {
        try {
            out.print(" " + attribute + "=\"" + value + "\"");
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttribute(PrintWriter out, String indentation, String attribute, String value) throws ExtendedRuntimeException {
        try {
            if (value != null && !value.equals("")) {
                value = XMLUtils.encode(value);
                out.print(" " + attribute + "=\"" + value + "\"");
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttribute(PrintWriter out, String indentation, String attribute, StringTypeBase value) throws ExtendedRuntimeException {
        try {
            if (value != null && value.getValue() != null && !value.getValue().trim().equals("")) {
                String v = XMLUtils.encode(value.getValue());
                out.print(" " + attribute + "=\"" + v + "\"");
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public static void writeAttributeForce(PrintWriter out, String indentation, String attribute, String value) throws ExtendedRuntimeException {
        try {
            if (value != null && !value.equals("")) {
                value = XMLUtils.encode(value);
                out.print(" " + attribute + "=\"" + value + "\"");
            } else {
                out.print(" " + attribute + "=\"\"");
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }
}

