/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebBean
extends BeanNode {
    public WebBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getWebUri() {
        return this.nodeValue("web-uri");
    }

    public String getContextRoot() {
        return this.nodeValue("context-root");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "web");
        if (this.getId() != null) {
            XMLUtils.writeAttribute(out, indentation, "id", this.getId());
        }
        XMLUtils.writeTagAttributeEnd(out, indentation, "web");
        WebBean.writeAll(this.getChildBean("web-uri"), out, indentation + "\t");
        WebBean.writeAll(this.getChildBean("context-root"), out, indentation + "\t");
        out.println(indentation + "</" + "web" + ">");
    }

    public String toString() {
        return this.getWebUri();
    }

    private void init(Node rootNode) {
        this.setXpath("web");
        Vector<StringBean> webUri = new Vector<StringBean>(1);
        Vector<StringBean> contextRoot = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("web-uri")) {
                bean = new StringBean(node, this, "web-uri");
                webUri.add(bean);
                continue;
            }
            if (!name.equals("context-root")) continue;
            bean = new StringBean(node, this, "context-root");
            contextRoot.add(bean);
        }
        this.recordXpathForBeans("web-uri", webUri);
        this.recordXpathForBeans("context-root", contextRoot);
    }
}

