/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaglibBean
extends BeanNode {
    public TaglibBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getTaglibUri() {
        return this.nodeValue("taglib-uri");
    }

    public String getTaglibLocation() {
        return this.nodeValue("taglib-location");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "taglib" + ">");
        TaglibBean.writeAll(this.getChildBean("taglib-uri"), out, indentation + "\t");
        TaglibBean.writeAll(this.getChildBean("taglib-location"), out, indentation + "\t");
        out.println(indentation + "</" + "taglib" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("taglib");
        Vector<StringBean> taglibUri = new Vector<StringBean>(1);
        Vector<StringBean> taglibLocation = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("taglib-uri")) {
                bean = new StringBean(node, this, "taglib-uri");
                taglibUri.add(bean);
            }
            if (!name.equals("taglib-location")) continue;
            bean = new StringBean(node, this, "taglib-location");
            taglibLocation.add(bean);
        }
        this.recordXpathForBeans("taglib-uri", taglibUri);
        this.recordXpathForBeans("taglib-location", taglibLocation);
    }
}

