/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletMappingBean
extends BeanNode {
    public ServletMappingBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getServletName() {
        return this.nodeValue("servlet-name");
    }

    public String getUrlPattern() {
        return this.nodeValue("url-pattern");
    }

    public String jtreeToolTip() {
        return "Servlet Mapping";
    }

    public String toString() {
        return this.getServletName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "servlet-mapping" + ">");
        ServletMappingBean.writeAll(this.getChildBean("servlet-name"), out, indentation + "\t");
        ServletMappingBean.writeAll(this.getChildBean("url-pattern"), out, indentation + "\t");
        out.println(indentation + "</" + "servlet-mapping" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("servlet-mapping");
        Vector<StringBean> servletName = new Vector<StringBean>(1);
        Vector<StringBean> urlPattern = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("servlet-name")) {
                bean = new StringBean(node, this, "servlet-name");
                servletName.add(bean);
                continue;
            }
            if (!name.equals("url-pattern")) continue;
            bean = new StringBean(node, this, "url-pattern");
            urlPattern.add(bean);
        }
        this.recordXpathForBeans("servlet-name", servletName);
        this.recordXpathForBeans("url-pattern", urlPattern);
    }
}

