/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.AuthConstraintBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.UserDataConstraintBean;
import oracle.oc4j.admin.deploy.model.xml.WebResourceCollectionBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityConstraintBean
extends BeanNode {
    public SecurityConstraintBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    protected String[] listJTreeChildPaths() {
        return new String[]{"web-resource-collection"};
    }

    public BeanNode[] childBeansToDisplay() {
        DDBean[] authConstraint = this.getChildBean("auth-constraint");
        DDBean[] userDataConstraint = this.getChildBean("user-data-constraint");
        int size = 0;
        if (authConstraint != null && authConstraint.length > 0) {
            ++size;
        }
        if (userDataConstraint != null && userDataConstraint.length > 0) {
            ++size;
        }
        BeanNode[] nodes = new BeanNode[size];
        size = 0;
        if (authConstraint != null && authConstraint.length > 0) {
            nodes[size] = (BeanNode)authConstraint[0];
            ++size;
        }
        if (userDataConstraint != null && userDataConstraint.length > 0) {
            nodes[size] = (BeanNode)userDataConstraint[0];
        }
        return nodes;
    }

    public String jtreeToolTip() {
        return "Security Constraint";
    }

    public String toString() {
        return "security-constraint";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "security-constraint" + ">");
        SecurityConstraintBean.writeAll(this.getChildBean("web-resource-collection"), out, indentation + "\t");
        SecurityConstraintBean.writeAll(this.getChildBean("auth-constraint"), out, indentation + "\t");
        SecurityConstraintBean.writeAll(this.getChildBean("user-data-constraint"), out, indentation + "\t");
        out.println(indentation + "</" + "security-constraint" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("security-constraint");
        Vector<WebResourceCollectionBean> webResourceCollections = new Vector<WebResourceCollectionBean>();
        Vector<WebResourceCollectionBean> authConstraints = new Vector<WebResourceCollectionBean>();
        Vector<WebResourceCollectionBean> userDataConstraints = new Vector<WebResourceCollectionBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("web-resource-collection")) {
                bean = new WebResourceCollectionBean(node, this);
                webResourceCollections.add((WebResourceCollectionBean)bean);
                continue;
            }
            if (name.equals("auth-constraint")) {
                bean = new AuthConstraintBean(node, this);
                authConstraints.add((WebResourceCollectionBean)bean);
                continue;
            }
            if (!name.equals("user-data-constraint")) continue;
            bean = new UserDataConstraintBean(node, this);
            userDataConstraints.add((WebResourceCollectionBean)bean);
        }
        this.recordXpathForBeans("web-resource-collection", webResourceCollections);
        this.recordXpathForBeans("auth-constraint", authConstraints);
        this.recordXpathForBeans("user-data-constraint", userDataConstraints);
    }
}

