/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InitParamBean
extends BeanNode {
    public InitParamBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getParamName() {
        return this.nodeValue("param-name");
    }

    public String getParamValue() {
        return this.nodeValue("param-value");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "init-param" + ">");
        InitParamBean.writeAll(this.getChildBean("param-name"), out, indentation + "\t");
        InitParamBean.writeAll(this.getChildBean("param-value"), out, indentation + "\t");
        InitParamBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        out.println(indentation + "</" + "init-param" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("init-param");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> paramName = new Vector<StringBean>(1);
        Vector<StringBean> paramValue = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("param-name")) {
                bean = new StringBean(node, this, "param-name");
                paramName.add(bean);
            }
            if (name.equals("param-value")) {
                bean = new StringBean(node, this, "param-value");
                paramValue.add(bean);
            }
            if (!name.equals("description")) continue;
            bean = new StringBean(node, this, "description");
            description.add(bean);
        }
        this.recordXpathForBeans("param-name", paramName);
        this.recordXpathForBeans("param-value", paramValue);
        this.recordXpathForBeans("description", description);
    }
}

