/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnvEntryBean
extends BeanNode {
    public EnvEntryBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getEnvEntryName() {
        return this.nodeValue("env-entry-name");
    }

    public String getEnvEntryType() {
        return this.nodeValue("env-entry-type");
    }

    public String getEnvEntryValue() {
        return this.nodeValue("env-entry-value");
    }

    public String jtreeToolTip() {
        return "Environment Entry";
    }

    public String toString() {
        return this.getEnvEntryName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "env-entry" + ">");
        EnvEntryBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        EnvEntryBean.writeAll(this.getChildBean("env-entry-name"), out, indentation + "\t");
        EnvEntryBean.writeAll(this.getChildBean("env-entry-type"), out, indentation + "\t");
        EnvEntryBean.writeAll(this.getChildBean("env-entry-value"), out, indentation + "\t");
        out.println(indentation + "</" + "env-entry" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("env-entry");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> envEntryName = new Vector<StringBean>(1);
        Vector<StringBean> envEntryType = new Vector<StringBean>(1);
        Vector<StringBean> envEntryValue = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add(bean);
            }
            if (name.equals("env-entry-name")) {
                bean = new StringBean(node, this, "env-entry-name");
                envEntryName.add(bean);
            }
            if (name.equals("env-entry-type")) {
                bean = new StringBean(node, this, "env-entry-type");
                envEntryType.add(bean);
            }
            if (!name.equals("env-entry-value")) continue;
            bean = new StringBean(node, this, "env-entry-value");
            envEntryValue.add(bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("env-entry-name", envEntryName);
        this.recordXpathForBeans("env-entry-type", envEntryType);
        this.recordXpathForBeans("env-entry-value", envEntryValue);
    }
}

