/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.ContainerTransactionBean;
import oracle.oc4j.admin.deploy.model.xml.ExcludeListBean;
import oracle.oc4j.admin.deploy.model.xml.MessageDestinationBean;
import oracle.oc4j.admin.deploy.model.xml.MethodPermissionBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityRoleBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssemblyDescriptorBean
extends BeanNode {
    public AssemblyDescriptorBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "assembly-descriptor" + ">");
        AssemblyDescriptorBean.writeAll(this.getChildBean("security-role"), out, indentation + "\t");
        AssemblyDescriptorBean.writeAll(this.getChildBean("method-permission"), out, indentation + "\t");
        AssemblyDescriptorBean.writeAll(this.getChildBean("container-transaction"), out, indentation + "\t");
        AssemblyDescriptorBean.writeAll(this.getChildBean("message-destination"), out, indentation + "\t");
        AssemblyDescriptorBean.writeAll(this.getChildBean("exclude-list"), out, indentation + "\t");
        out.println(indentation + "</" + "assembly-descriptor" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("assembly-descriptor");
        Vector<SecurityRoleBean> securityRoles = new Vector<SecurityRoleBean>();
        Vector<SecurityRoleBean> methodPermissions = new Vector<SecurityRoleBean>();
        Vector<SecurityRoleBean> containerTransactions = new Vector<SecurityRoleBean>();
        Vector<SecurityRoleBean> messageDestinations = new Vector<SecurityRoleBean>();
        Vector<SecurityRoleBean> excludeList = new Vector<SecurityRoleBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("security-role")) {
                bean = new SecurityRoleBean(node, this);
                securityRoles.add((SecurityRoleBean)bean);
            }
            if (name.equals("method-permission")) {
                bean = new MethodPermissionBean(node, this);
                methodPermissions.add((SecurityRoleBean)bean);
            }
            if (name.equals("container-transaction")) {
                bean = new ContainerTransactionBean(node, this);
                containerTransactions.add((SecurityRoleBean)bean);
            }
            if (name.equals("message-destination")) {
                bean = new MessageDestinationBean(node, this);
                messageDestinations.add((SecurityRoleBean)bean);
            }
            if (!name.equals("exclude-list")) continue;
            bean = new ExcludeListBean(node, this);
            excludeList.add((SecurityRoleBean)bean);
        }
        this.recordXpathForBeans("security-role", securityRoles);
        this.recordXpathForBeans("method-permission", methodPermissions);
        this.recordXpathForBeans("container-transaction", containerTransactions);
        this.recordXpathForBeans("message-destination", messageDestinations);
        this.recordXpathForBeans("exclude-list", excludeList);
    }
}

