/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.model.xml.WSStdXml;
import oracle.oc4j.admin.deploy.model.xml.WarStdXml;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.xml.parser.v2.XMLDocument;

public class WarFile
extends J2eeFile
implements DeployableObject {
    public WarFile(File warfile) throws ExtendedRuntimeException {
        this(warfile, null, null, false);
    }

    public WarFile(File warfile, boolean dtdValidation) throws ExtendedRuntimeException {
        this(warfile, null, null, dtdValidation);
    }

    public WarFile(File warfile, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(warfile, null, jarEntry, parent, dtdValidation);
    }

    public WarFile(String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(null, altDD, jarEntry, parent, dtdValidation);
    }

    public WarFile(File warfile, String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        super(warfile, jarEntry, parent, dtdValidation);
        this.init(altDD);
    }

    public ModuleType getType() {
        return ModuleType.WAR;
    }

    public void addXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public boolean checkStdXml(BeanRootNode stdXml) {
        return this.checkParam(stdXml, "oracle.oc4j.admin.deploy.model.xml.WarStdXml");
    }

    public String getStdXmlEntry() {
        return "WEB-INF/web.xml";
    }

    public static WarFile copy(InputStream inStrm) throws ExtendedRuntimeException {
        try {
            File tmpWar = File.createTempFile("dep", ".war");
            WarFile.copyStreamToFile(inStrm, tmpWar);
            WarFile ret = new WarFile(tmpWar);
            ret._tmpFile = true;
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    private void init(String altDD) throws ExtendedRuntimeException {
        try {
            File warFile = this.getFile();
            XMLDocument doc = null;
            doc = altDD == null ? (warFile != null ? this.getXmlDocument(this.getStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getStdXmlEntry())) : this.getParent().getXmlDocument(altDD);
            if (doc == null) {
                if (altDD == null) {
                    if (warFile == null) {
                        throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this._entryName, this.getStdXmlEntry()}));
                    }
                    throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{warFile.getAbsolutePath(), this.getStdXmlEntry()}));
                }
                throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this.getParent().getFile().getAbsolutePath(), altDD}));
            }
            this.setStdXml(new WarStdXml(doc, this));
            doc = warFile != null ? this.getXmlDocument(this.getWSStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getWSStdXmlEntry());
            if (doc != null) {
                this.setWSStdXml(new WSStdXml(doc, this));
            }
        }
        catch (ExtendedRuntimeException ExT) {
            this.close();
            throw ExT;
        }
        catch (Throwable t) {
            this.close();
            throw new ExtendedRuntimeException(t);
        }
    }

    public String getWSStdXmlEntry() {
        return "WEB-INF/webservices.xml";
    }
}

