/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.file;

import java.io.File;
import java.io.InputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.model.xml.CarStdXml;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.xml.parser.v2.XMLDocument;

public class CarFile
extends J2eeFile
implements DeployableObject {
    public CarFile(File carfile) throws ExtendedRuntimeException {
        this(carfile, null, null, false);
    }

    public CarFile(File carfile, boolean dtdValidation) throws ExtendedRuntimeException {
        this(carfile, null, null, dtdValidation);
    }

    public CarFile(File carfile, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(carfile, null, jarEntry, parent, dtdValidation);
    }

    public CarFile(String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        this(null, altDD, jarEntry, parent, dtdValidation);
    }

    public CarFile(File carfile, String altDD, String jarEntry, EarFile parent, boolean dtdValidation) throws ExtendedRuntimeException {
        super(carfile, jarEntry, parent, dtdValidation);
        this.init(altDD);
    }

    public ModuleType getType() {
        return ModuleType.CAR;
    }

    public void addXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public void removeXpathListener(ModuleType type, String xpath, XpathListener xpl) {
    }

    public boolean checkStdXml(BeanRootNode stdXml) {
        return this.checkParam(stdXml, "oracle.oc4j.admin.deploy.model.xml.CarStdXml");
    }

    public String getStdXmlEntry() {
        return "META-INF/application-client.xml";
    }

    public static CarFile copy(InputStream inStrm) throws ExtendedRuntimeException {
        try {
            File tmpCar = File.createTempFile("dep", ".car");
            CarFile.copyStreamToFile(inStrm, tmpCar);
            CarFile ret = new CarFile(tmpCar);
            ret._tmpFile = true;
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    private void init(String altDD) throws ExtendedRuntimeException {
        try {
            File carFile = this.getFile();
            XMLDocument doc = null;
            doc = altDD == null ? (carFile != null ? this.getXmlDocument(this.getStdXmlEntry()) : this.getXmlDocument(this.getURI(), this.getStdXmlEntry())) : this.getParent().getXmlDocument(altDD);
            if (doc == null) {
                if (altDD == null) {
                    if (carFile == null) {
                        throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this._entryName, this.getStdXmlEntry()}));
                    }
                    throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{carFile.getAbsolutePath(), this.getStdXmlEntry()}));
                }
                throw new ExtendedRuntimeException(FormattingResourceBundle.DeploymentMessages.getString("missingStdDesc", new String[]{this.getParent().getFile().getAbsolutePath(), altDD}));
            }
            this.setStdXml(new CarStdXml(doc, this));
        }
        catch (ExtendedRuntimeException ExT) {
            this.close();
            throw ExT;
        }
        catch (Throwable t) {
            this.close();
            throw new ExtendedRuntimeException(t);
        }
    }
}

