/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.oc4j.admin.deploy.gui.ConfigPropertiesPanel;
import oracle.oc4j.admin.deploy.gui.ConfigurableElement;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElementFactory;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;

public abstract class ViewableJTreeNodeSupport
implements ViewableJTreeNode,
ConfigurableElement {
    private ViewableJTreeNode _parent = null;
    private Vector _jtreeChildren = new Vector();
    private boolean _rebuildChildren = true;
    private String _rebuildLock = new String("Rebuild lock");
    private JComponent _viewPane = null;
    private DataEntryElement[] _attrElements;
    private boolean _semiSelected;

    protected abstract void buildChildJTree();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildChildJTree() {
        String string = this._rebuildLock;
        synchronized (string) {
            if (this._rebuildChildren) {
                this._jtreeChildren.clear();
                this.buildChildJTree();
                this._rebuildChildren = false;
            }
        }
    }

    protected void setRebuildChildJTree(boolean flag) {
        this._rebuildChildren = flag;
    }

    public String viewHeaderString() {
        return null;
    }

    public int getNumJTreeChildren() {
        return this._jtreeChildren.size();
    }

    protected abstract boolean leaf();

    public void setJTreeParent(ViewableJTreeNode parent) {
        this._parent = parent;
    }

    public String jtreeToolTip() {
        return null;
    }

    public String jtreeIconName() {
        return null;
    }

    protected JComponent getcomponent() {
        return this._viewPane;
    }

    protected void setcomponent(JComponent comp) {
        this._viewPane = comp;
    }

    public JComponent viewComponent() throws CreationException {
        if (this._viewPane == null) {
            this._viewPane = new ConfigPropertiesPanel(this);
            this._viewPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 4));
        }
        return this._viewPane;
    }

    public void addJTreeChild(ViewableJTreeNode child) {
        this._jtreeChildren.add(child);
        child.setJTreeParent(this);
    }

    public void removeJTreeChild(ViewableJTreeNode child) {
        this._jtreeChildren.remove(child);
    }

    public TreeNode getChildAt(int childIndex) {
        this.rebuildChildJTree();
        return (TreeNode)this._jtreeChildren.elementAt(childIndex);
    }

    public int getChildCount() {
        this.rebuildChildJTree();
        return this._jtreeChildren.size();
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public int getIndex(TreeNode node) {
        this.rebuildChildJTree();
        return this._jtreeChildren.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isLeaf() {
        return this.leaf();
    }

    public Enumeration children() {
        this.rebuildChildJTree();
        return this._jtreeChildren.elements();
    }

    public ViewableJTree[] subTrees() {
        return null;
    }

    public DataEntryElement[] fetchAttributeElements() {
        if (this._attrElements == null) {
            this._attrElements = DataEntryElementFactory.createJavaBeanDataElements(this);
        }
        return this._attrElements;
    }

    public void setSemiSelected(boolean sel) {
        this._semiSelected = sel;
    }

    public boolean isSemiSelected() {
        return this._semiSelected;
    }

    public Collection getPopupMenuItems(ViewableJTree jtree) {
        return null;
    }
}

