/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.TargetSelectionListener;

public class StatusPane
extends JPanel
implements TargetSelectionListener {
    protected static final String CONNECT_STRING = "Connect";
    protected static final String DISCONNECT_STRING = "Disconnect";
    protected JButton _connectButton;
    protected JLabel _connectionLabel;
    protected JLabel _deployTargetLabel;

    public StatusPane(ActionListener listener) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 14, 8, 14));
        this._connectButton = new JButton(CONNECT_STRING);
        this._connectButton.addActionListener(listener);
        this.add((Component)this._connectButton, "West");
        this._connectionLabel = new JLabel("Not Connected", 4);
        this._deployTargetLabel = new JLabel("No Deploy Target Selected");
        this.add((Component)this._connectionLabel, "Center");
    }

    public void targetSelected(DeployTargetNode target) {
        this._deployTargetLabel.setText("Selected Deploy Target:  " + target.targetName());
    }

    public void targetDeselected(DeployTargetNode target) {
        this._deployTargetLabel.setText("No Deploy Target Selected");
    }

    public void setConnected(String url) {
        this._connectionLabel.setText("Connected to " + url);
        this._connectionLabel.setHorizontalAlignment(2);
        this.remove(this._connectButton);
        this.add((Component)this._deployTargetLabel, "East");
    }

    public void setDisconnected() {
        this.add((Component)this._connectButton, "West");
        this.remove(this._deployTargetLabel);
        this._connectionLabel.setText("Not Connected");
        this._connectionLabel.setHorizontalAlignment(4);
        this._deployTargetLabel.setText("No Deploy Target Selected");
    }
}

