/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.shared.StateType;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.DialogListener;
import oracle.oc4j.admin.deploy.gui.OperationStatus;

public class OperationStatusDialog
extends JDialog
implements ActionListener {
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    protected JLabel _header;
    protected JTextArea _textArea;
    protected JTextArea[] _targetTextAreas;
    protected JPanel _buttonPane;
    protected JButton _okButton;
    protected JButton _cancelButton;
    protected JTabbedPane _textPane;
    protected String _appName;
    protected String _method;
    protected DialogListener _listener;
    protected Object[] _targets;
    protected String[] _names;

    public OperationStatusDialog(JFrame parent, DialogListener lstnr, String method, String appName, Object[] targets, String[] names) {
        super(parent);
        this._method = method;
        this._appName = appName;
        this._listener = lstnr;
        this._targets = targets;
        this._names = names;
        this.setTitle(method + " Operation Status Window");
        this.setSize(new Dimension(450, 350));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        String message = "<html>Performing operation <font color=red>" + method + "</font> on application <font color=red>" + appName + "</font>";
        this._header = new JLabel(message, 0);
        this._header.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        contentPane.add((Component)this._header, "North");
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this._textArea.setBorder(BorderFactory.createCompoundBorder(this._textArea.getBorder(), BorderFactory.createEmptyBorder(8, 5, 0, 5)));
        if (targets != null && targets.length > 1) {
            this._textPane = new JTabbedPane();
            this._textPane.setBackground(Deployer.TreeBackgroundColor);
            this._textPane.addTab("cluster", this._textArea);
            this._targetTextAreas = new JTextArea[targets.length];
            for (int i = 0; i < names.length; ++i) {
                JTextArea text = new JTextArea();
                text.setEditable(false);
                text.setBorder(BorderFactory.createCompoundBorder(text.getBorder(), BorderFactory.createEmptyBorder(8, 5, 0, 5)));
                this._targetTextAreas[i] = text;
                this._textPane.addTab(names[i], new JScrollPane(this._targetTextAreas[i]));
            }
            contentPane.add((Component)this._textPane, "Center");
        } else {
            contentPane.add((Component)new JScrollPane(this._textArea), "Center");
        }
        this._buttonPane = new JPanel();
        this._buttonPane.setOpaque(false);
        this._buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this._okButton = new JButton(OK_STRING);
        this._okButton.addActionListener(this);
        this._cancelButton = new JButton(CANCEL_STRING);
        this._cancelButton.addActionListener(this);
        this._cancelButton.setEnabled(false);
        this._okButton.setEnabled(false);
        this._buttonPane.add(this._okButton);
        this._buttonPane.add(this._cancelButton);
        contentPane.add((Component)this._buttonPane, "South");
        this.getRootPane().setDefaultButton(this._okButton);
        this.setLocationRelativeTo(parent);
    }

    public void showDialog() {
        this.updateStatus("Beginning operation " + this._method + "\n");
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        String buttonText = ((JButton)e.getSource()).getText();
        if (buttonText.equals(CANCEL_STRING)) {
            this._cancelButton.setEnabled(false);
            this._listener.cancelButtonPressed();
        } else {
            this.dispose();
        }
    }

    protected void operationCompleted(OperationStatus status) {
        this.setHeader("<html>Operation <font color=red>" + this._method + "</font> on application <font color=red>" + this._appName + "</font> " + status);
        if (this._targetTextAreas != null) {
            this.updateStatus("\nCluster " + this._method + " " + status + ".");
        }
        this.enableOkButton();
    }

    protected void updateStatus(String message) {
        this._textArea.append(message + "\n");
        this._textArea.setCaretPosition(this._textArea.getDocument().getLength());
    }

    protected void updateStatus(String message, Object target, StateType state) {
        JTextArea text = this._textArea;
        if (this._targetTextAreas != null && target != null) {
            for (int i = 0; i < this._targets.length; ++i) {
                if (!this._targets[i].equals(target)) continue;
                text = this._targetTextAreas[i];
                if (state == null) break;
                if (state.equals(StateType.COMPLETED)) {
                    this.putMessage(this._textArea, this._method + " complete on instance " + this._names[i]);
                    this._textPane.setForegroundAt(i + 1, new Color(0, 128, 0));
                    break;
                }
                if (!state.equals(StateType.FAILED)) break;
                this.putMessage(this._textArea, this._method + " failed on instance " + this._names[i]);
                this._textPane.setForegroundAt(i + 1, new Color(128, 0, 0));
                break;
            }
        }
        this.putMessage(text, message);
    }

    private void putMessage(JTextArea text, String message) {
        text.append(message + "\n");
        text.setCaretPosition(text.getDocument().getLength());
    }

    protected void setHeader(String header) {
        this._header.setText(header);
    }

    protected void enableCancelButton() {
        this._cancelButton.setEnabled(true);
    }

    protected void enableOkButton() {
        this._cancelButton.setEnabled(false);
        this._okButton.setEnabled(true);
    }

    protected void operationFailed(Throwable t) {
        this.operationFailed("ERROR: " + t.getMessage());
    }

    protected void operationFailed(String message) {
        this.updateStatus(message);
        this.operationCompleted(OperationStatus.FAILURE);
    }
}

