/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Date;
import java.util.Map;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import oracle.oc4j.admin.deploy.gui.ApplicationJTree;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.JVMNode;
import oracle.oc4j.admin.deploy.gui.ResourceJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ClusterHelper;
import oracle.oc4j.admin.deploy.spi.JVMInfo;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;

public class Oc4jNode
extends ViewableJTreeNodeSupport
implements DeployTargetNode {
    protected String _targetName;
    protected String _oc4jName;
    protected String _instanceName;
    protected String _clusterName;
    protected String _host;
    protected String _description;
    protected boolean _isTargeted = false;
    protected Target _target;
    protected DeploymentManager _manager;
    private ApplicationJTree _appTree;
    private ResourceJTree _resourceTree;

    public Oc4jNode(Target target, DeploymentManager manager, String name) {
        this._target = target;
        this._clusterName = name;
        this._manager = manager;
        this._targetName = this._target.getName();
        Map uriMap = ClusterHelper.getDeployerURIComponents(this._targetName);
        this._oc4jName = (String)uriMap.get("oc4j_instance");
        this._instanceName = (String)uriMap.get("as_instance");
        this._host = ClusterHelper.getDeployerURITargetHost(this._targetName);
        this._appTree = ApplicationJTree.createApplicationJTree(manager, target);
        this._resourceTree = ResourceJTree.createResourceJTree(manager, target);
    }

    public String getName() {
        return this._oc4jName;
    }

    public String getASInstance() {
        return this._instanceName;
    }

    public String getHost() {
        return this._host;
    }

    public String getStartTime() {
        long st = ((ProprietaryTarget)this._target).getStartTime();
        return new Date(st).toString();
    }

    public String jtreeIconName() {
        return "oc4j";
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return "OC4J Installation";
    }

    public String getURL() {
        return this._targetName;
    }

    public void targeted(boolean flag) {
        this._isTargeted = flag;
    }

    public boolean targeted() {
        return this._isTargeted;
    }

    public ApplicationJTree appTree() {
        return this._appTree;
    }

    public ResourceJTree resourceTree() {
        return this._resourceTree;
    }

    public ViewableJTree[] subTrees() {
        return new ViewableJTree[]{this.appTree(), this.resourceTree()};
    }

    public void buildChildJTree() {
        ProprietaryTarget pt = (ProprietaryTarget)this._target;
        JVMInfo[] jvms = pt.getJVMs();
        for (int j = 0; j < jvms.length; ++j) {
            try {
                this.addJTreeChild(new JVMNode(jvms[j].getobjectName(), this._manager));
                continue;
            }
            catch (Exception e) {
                GuiUtil.errDialog("Got exception adding JVM node: " + e.getMessage());
            }
        }
    }

    protected boolean leaf() {
        return false;
    }

    public Target[] returnTargets() {
        return new Target[]{this._target};
    }

    public String targetName() {
        return this.toString();
    }

    public String toString() {
        return this._oc4jName + " (" + this._instanceName + ")";
    }
}

