/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.oc4j.admin.deploy.gui.GroupNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.management.shared.Group;

public class GroupRootNode
extends ViewableJTreeNodeSupport {
    protected String _viewHeaderString;
    protected String _appName;
    protected ProprietaryTargetModuleID _moduleID;
    protected Set _allPermissions = new HashSet();

    public GroupRootNode(ProprietaryTargetModuleID moduleID, String name) {
        this._viewHeaderString = "Groups defined for application " + name;
        this._appName = name;
        this._moduleID = moduleID;
    }

    public String childType() {
        return "Group";
    }

    public void addPermissions(Collection perms) {
        Iterator it = perms.iterator();
        while (it.hasNext()) {
            this._allPermissions.add(it.next());
        }
    }

    public String[] allKnownPermissions() {
        return this._allPermissions.toArray(new String[this._allPermissions.size()]);
    }

    public String viewHeaderString() {
        return this._viewHeaderString;
    }

    public String toString() {
        return "Groups";
    }

    public void buildChildJTree() {
        try {
            Set groups = this._moduleID.getGroups();
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                Group group = (Group)it.next();
                GroupNode gnode = new GroupNode(group.getName(), group.getDescription());
                this.addJTreeChild(gnode);
            }
        }
        catch (Exception ex) {
            GuiUtil.errDialog("Exception getting Groups info: " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
    }

    public boolean leaf() {
        return false;
    }
}

