/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.AppJTreeBase;
import oracle.oc4j.admin.deploy.gui.AppRootNode;
import oracle.oc4j.admin.deploy.gui.ApplicationJTree;
import oracle.oc4j.admin.deploy.gui.ClusterNode;
import oracle.oc4j.admin.deploy.gui.Controller;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.DeployTargetInfo;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.Oc4jNode;
import oracle.oc4j.admin.deploy.gui.ResourceJTree;
import oracle.oc4j.admin.deploy.gui.TargetModuleNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.spi.ClusterDeploymentManager;

public class ClusterJTree
extends ViewableJTree
implements ActionListener,
DeployTargetInfo {
    protected JPopupMenu _oc4jNodePopup;
    protected static final String SELECT_TARGET_MENU_STRING = "Select Target for Deployment";
    protected static final String DESELECT_TARGET_MENU_STRING = "Deselect Target";
    protected static final String START_MENU_STRING = "Start";
    protected static final String STOP_MENU_STRING = "Stop";
    protected JMenuItem _selectClusterMenuItem;
    protected JMenuItem _deselectClusterMenuItem;
    protected JMenuItem _startMenuItem;
    protected JMenuItem _stopMenuItem;
    protected Controller _controller;
    protected DeploymentManager _manager;

    private ClusterJTree(ViewableJTreeNode rootNode, DeploymentManager manager) {
        super(rootNode, true);
        this.createOc4jNodePopupMenu();
        this._manager = manager;
        this._controller = ControllerImpl.getSingletonController();
    }

    public static ClusterJTree createClusterJTree(DeploymentManager manager, String name, String url) {
        Controller cont = ControllerImpl.getSingletonController();
        return new ClusterJTree((ViewableJTreeNode)new ClusterNode(manager, name, url), manager);
    }

    private void createOc4jNodePopupMenu() {
        this._oc4jNodePopup = new JPopupMenu();
        this._selectClusterMenuItem = new JMenuItem(SELECT_TARGET_MENU_STRING);
        this._deselectClusterMenuItem = new JMenuItem(DESELECT_TARGET_MENU_STRING);
        this._selectClusterMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._deselectClusterMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._selectClusterMenuItem.setFont(GuiUtil.getRegularFont());
        this._deselectClusterMenuItem.setFont(GuiUtil.getRegularFont());
        this._selectClusterMenuItem.addActionListener(this);
        this._deselectClusterMenuItem.addActionListener(this);
        this._deselectClusterMenuItem.setEnabled(false);
        this._oc4jNodePopup.add(this._selectClusterMenuItem);
        this._oc4jNodePopup.add(this._deselectClusterMenuItem);
    }

    public JPopupMenu getPopupForNode(ViewableJTreeNode node) {
        if (node instanceof DeployTargetNode) {
            DeployTargetNode dtNode = (DeployTargetNode)((Object)node);
            boolean isSel = this._controller.isDeployTargetSelected();
            this._selectClusterMenuItem.setEnabled(!isSel || !dtNode.targeted());
            this._deselectClusterMenuItem.setEnabled(isSel && dtNode.targeted());
            return this._oc4jNodePopup;
        }
        return null;
    }

    public void appUnDeployed(TargetModuleNode node, TargetModuleID id) {
        AppRootNode appRootNode = (AppRootNode)node.getParent();
        AppJTreeBase appTree = appRootNode.getAppTree();
        appTree.appUnDeployed(node, id);
        ClusterNode rootNode = (ClusterNode)this.getRootNode();
        if (rootNode.appTree() == appTree) {
            Enumeration e = rootNode.children();
            while (e.hasMoreElements()) {
                Oc4jNode oNode = (Oc4jNode)e.nextElement();
                oNode.appTree().appUnDeployed(node.getName());
            }
        } else {
            rootNode.appTree().appUnDeployed(node.getName());
        }
    }

    public void newAppDeployed(String appName, TargetModuleID id, boolean selectApp) {
        ClusterNode rootNode = (ClusterNode)this.getRootNode();
        TreePath treepath = new TreePath(rootNode);
        TargetModuleID[] allIds = this.getAllTargetModuleIDsForAppFromTargets(appName, rootNode.returnTargets());
        boolean addToCluster = false;
        if (!rootNode.targeted()) {
            Target target = id.getTarget();
            Oc4jNode cnode = rootNode.getOc4jNode(target);
            cnode.appTree().newAppDeployed(appName, id, true);
            treepath = treepath.pathByAddingChild(cnode);
            if (allIds.length == rootNode.getChildCount()) {
                addToCluster = true;
            }
        } else {
            addToCluster = true;
            Enumeration e = rootNode.children();
            block0: while (e.hasMoreElements()) {
                Oc4jNode oNode = (Oc4jNode)e.nextElement();
                if (oNode.appTree().getOneTargetModuleIDForApp(appName) != null) continue;
                for (int i = 0; i < allIds.length; ++i) {
                    if (!allIds[i].getTarget().equals(oNode.returnTargets()[0])) continue;
                    oNode.appTree().newAppDeployed(appName, id, false);
                    continue block0;
                }
            }
        }
        if (addToCluster && rootNode.appTree().getOneTargetModuleIDForApp(appName) == null) {
            rootNode.appTree().newClusterAppDeployed(appName, allIds, rootNode.targeted());
        }
        if (treepath != null) {
            this.makeVisible(treepath);
            this.setSelectionPath(treepath);
        }
    }

    public TargetModuleID getOneTargetModuleIDForApp(String appName) {
        ApplicationJTree appTree = this.appTree();
        return appTree.getOneTargetModuleIDForApp(appName);
    }

    public TargetModuleID[] getAllTargetModuleIDsForApp(String appName) {
        Target[] targets = this._controller.getSelectedTargets();
        return this.getAllTargetModuleIDsForAppFromTargets(appName, targets);
    }

    private TargetModuleID[] getAllTargetModuleIDsForAppFromTargets(String appName, Target[] targets) {
        return ((ClusterDeploymentManager)this._manager).getTargetModuleIDsForApplication(appName, targets);
    }

    public String[] getAppsForSelectedTargets() {
        ApplicationJTree appTree = this.appTree();
        return appTree.getAppsForSelectedTargets();
    }

    public String[] getWebSitesForSelectedTargets() {
        ClusterNode rootNode = (ClusterNode)this.getRootNode();
        ResourceJTree resourceTree = null;
        if (rootNode.targeted()) {
            resourceTree = rootNode.resourceTree();
        } else {
            Target[] targets = this._controller.getSelectedTargets();
            Oc4jNode cnode = rootNode.getOc4jNode(targets[0]);
            resourceTree = cnode.resourceTree();
        }
        return resourceTree.getWebSiteNames();
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = this.getLastSelectedPathComponent();
        DeployTargetNode node = (DeployTargetNode)obj;
        if (e.getActionCommand().equals(SELECT_TARGET_MENU_STRING)) {
            this._controller.selectTarget(node);
        } else {
            this._controller.deselectTarget(node);
        }
    }

    public DeployTargetNode[] getAllPossibleTargets() {
        int numTargets = this.getRootNode().getChildCount();
        DeployTargetNode[] targets = new DeployTargetNode[numTargets + 1];
        targets[0] = (DeployTargetNode)((Object)this.getRootNode());
        int i = 1;
        Enumeration<? extends TreeNode> e = this.getRootNode().children();
        while (e.hasMoreElements()) {
            targets[i++] = (DeployTargetNode)((Object)e.nextElement());
        }
        return targets;
    }

    private ApplicationJTree appTree() {
        ClusterNode rootNode = (ClusterNode)this.getRootNode();
        ApplicationJTree appTree = null;
        if (rootNode.targeted()) {
            appTree = rootNode.appTree();
        } else {
            Target[] targets = this._controller.getSelectedTargets();
            Oc4jNode cnode = rootNode.getOc4jNode(targets[0]);
            appTree = cnode.appTree();
        }
        return appTree;
    }
}

