/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.CreationException;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.PropertyComponent;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.shared.util.PropertyDescriptorComparator;

public class BeanSheetPane
extends JPanel {
    private boolean _editable;

    public BeanSheetPane(Object bean, boolean editable, Class baseClass, boolean showDefaults) throws CreationException {
        ViewableJTreeNode node;
        this._editable = editable;
        this.setLayout(new BorderLayout());
        this.setBackground(Deployer.ViewBackgroundColor);
        if (bean instanceof ViewableJTreeNode && (node = (ViewableJTreeNode)bean).viewHeaderString() != null) {
            JLabel label = new JLabel(node.viewHeaderString(), 2);
            label.setBorder(BorderFactory.createEmptyBorder(3, 0, 7, 0));
            label.setForeground(Deployer.ViewHeaderColor);
            label.setFont(GuiUtil.getRegularFont());
            this.add((Component)label, "North");
        }
        try {
            BeanInfo beanInfo = baseClass != null ? Introspector.getBeanInfo(bean.getClass(), baseClass) : Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            if (descriptors.length == 0) {
                return;
            }
            Arrays.sort(descriptors, new PropertyDescriptorComparator());
            JPanel gridPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            gridPanel.setLayout(gridbag);
            gridPanel.setOpaque(false);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.ipady = 4;
            int y = 0;
            for (int i = 0; i < descriptors.length; ++i) {
                Method readMethod;
                Object obj;
                JLabel label = new JLabel(descriptors[i].getDisplayName(), 2);
                editable = this._editable & descriptors[i].getWriteMethod() != null;
                if (editable) {
                    label.setBackground(Deployer.EditableValueLabelBackgroundColor);
                    label.setForeground(Deployer.LabelForegroundColor);
                } else {
                    label.setBackground(Deployer.TreeBackgroundColor);
                }
                label.setOpaque(true);
                label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
                c.gridy = y;
                c.gridx = 0;
                c.weightx = 0.0;
                if (i + 1 == descriptors.length) {
                    c.weighty = 1.0;
                    c.anchor = 11;
                }
                gridbag.setConstraints(label, c);
                PropertyEditor editor = null;
                PropertyEditor defaultEditor = null;
                Class<?> propEdClass = descriptors[i].getPropertyEditorClass();
                Class<?> propertyType = descriptors[i].getPropertyType();
                if (propEdClass != null) {
                    editor = (PropertyEditor)propEdClass.newInstance();
                    defaultEditor = (PropertyEditor)propEdClass.newInstance();
                } else {
                    propertyType = descriptors[i].getPropertyType();
                    editor = PropertyEditorManager.findEditor(propertyType);
                    defaultEditor = PropertyEditorManager.findEditor(propertyType);
                }
                if (editor == null) {
                    GuiUtil.errDialog("Could not find property editor for type " + propertyType);
                    continue;
                }
                if (editor.supportsCustomEditor()) {
                    label.setBackground(Deployer.CustomValueLabelBackgroundColor);
                }
                if ((obj = (readMethod = descriptors[i].getReadMethod()).invoke(bean, null)) == null) {
                    label.setBackground(Deployer.NoValueLabelBackgroundColor);
                }
                Object defaultObj = null;
                try {
                    StringBuffer buf = new StringBuffer(descriptors[i].getName());
                    buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
                    String methodName = "default" + buf;
                    Method getDefaultObjectMethod = bean.getClass().getMethod(methodName, null);
                    defaultObj = getDefaultObjectMethod.invoke(bean, null);
                    defaultEditor.setValue(defaultObj);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                gridPanel.add(label);
                if (obj != null) {
                    editor.setValue(obj);
                }
                if (editable) {
                    editor.addPropertyChangeListener(new ChangeListener(bean, editor, descriptors[i].getWriteMethod(), label));
                }
                c.gridx = 1;
                c.weightx = 5.0;
                PropertyComponent propComp = new PropertyComponent(descriptors[i].getName(), editor, editable, defaultEditor);
                Dimension propDim = propComp.getPreferredSize();
                Dimension labelDim = label.getPreferredSize();
                propComp.setPreferredSize(new Dimension((int)propDim.getWidth(), (int)labelDim.getHeight()));
                gridbag.setConstraints(propComp, c);
                gridPanel.add(propComp);
                if (showDefaults) {
                    c.gridx = 2;
                    JLabel defaultValue = null;
                    String defaultStr = defaultEditor.getAsText();
                    if (defaultStr == null || defaultStr.equals("null") || defaultStr.equals("")) {
                        defaultStr = " ";
                    }
                    defaultValue = new JLabel(defaultStr, 2);
                    defaultValue.setOpaque(true);
                    defaultValue.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 10)));
                    defaultValue.setBackground(Deployer.ValueBackgroundColor);
                    defaultValue.setForeground(Deployer.ValueForegroundColor);
                    gridbag.setConstraints(defaultValue, c);
                    gridPanel.add(defaultValue);
                }
                ++y;
            }
            this.add((Component)gridPanel, "Center");
        }
        catch (Exception ex) {
            throw new CreationException(ex);
        }
    }

    public void setHeader(String header) {
        JLabel label = new JLabel(header, 2);
        label.setBorder(BorderFactory.createEmptyBorder(3, 0, 7, 0));
        label.setForeground(Deployer.ViewHeaderColor);
        label.setFont(GuiUtil.getRegularFont());
        this.add((Component)label, "North");
    }

    class ChangeListener
    implements PropertyChangeListener {
        Object _bean;
        PropertyEditor _editor;
        Method _writeMethod;
        JLabel _label;

        public ChangeListener(Object bean, PropertyEditor editor, Method writeMethod, JLabel label) {
            this._bean = bean;
            this._editor = editor;
            this._writeMethod = writeMethod;
            this._label = label;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                this._writeMethod.invoke(this._bean, this._editor.getValue());
                if (!this._editor.supportsCustomEditor()) {
                    if (this._editor.getValue() == null) {
                        this._label.setBackground(Deployer.NoValueLabelBackgroundColor);
                    } else {
                        this._label.setBackground(Deployer.EditableValueLabelBackgroundColor);
                    }
                }
            }
            catch (Exception ex) {
                GuiUtil.errDialog(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }
}

