/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class TestDataSourceCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-testDataSource";
    static final String APPNAME = "-applicationName";
    static final String DATASOURCENAME = "-datasourceName";
    static final String SQLSTMT = "-sqlStatement";
    static final String USER = "-dbUser";
    static final String PASSWORD = "-dbPassword";
    static final String COMMANDMENU = "-testDataSource -datasourceName <datasourceName> -sqlStatement <sqlStatement>";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDataSource\n   - Test a datasource connection.\n\nValid switches are: \n   -datasourceName <datasourceName>                    - Required  The datasource to test.\n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -dbUser <dbUser>                                    - Optional  The user to use.\n   -dbPassword <dbPassword>                            - Optional  The password to use.\n\n";
    String _applicationName;
    String _datasourceName;
    String _sqlStatement;
    String _user;
    String _password;

    public TestDataSourceCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-testDataSource subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(DATASOURCENAME)) {
                this._datasourceName = this.getNextArgument("-datasourceName ");
                continue;
            }
            if (command.equalsIgnoreCase(SQLSTMT)) {
                this._sqlStatement = this.getNextArgument("-sqlStatement ");
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument("-dbUser ");
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument("-dbPassword ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_testDataSource_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._datasourceName, DATASOURCENAME);
        this.checkArgIsNull(this._sqlStatement, SQLSTMT);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.testDataSource(this._applicationName, this._datasourceName, this._sqlStatement, this._user, this._password));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("testDataSource_error", new String[]{e.getMessage()}), e);
        }
    }
}

