/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandParser;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ScriptCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-script";
    public static final String COMMANDMENU = "-script <filename>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -script <filename>\n   - Runs multiple commands specified by the user via a script file.\n\n";
    private String _scriptName = this.getNextArgument("script file name");

    public ScriptCommand(List args) throws AdminCommandException {
        super(args);
        if (!this.isArgsEmpty()) {
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_script_switch", new String[]{this.readNextArgument()}), COMMANDNAME);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute() throws AdminCommandException {
        LineNumberReader scriptReader = null;
        int lineNum = 0;
        try {
            try {
                scriptReader = new LineNumberReader(new FileReader(this._scriptName));
                String line = null;
                while ((line = scriptReader.readLine()) != null) {
                    ++lineNum;
                    if (line.startsWith(";") || line.equals("")) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    ArrayList<String> arguments = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        arguments.add(st.nextToken());
                    }
                    AdminCommandBase command = AdminCommandParser.parse(arguments);
                    command.execute(this._j2eeDeplMgr);
                }
                Object var8_11 = null;
                if (scriptReader == null) return;
            }
            catch (FileNotFoundException fnfe) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("script_file_not_found", new String[]{this._scriptName}));
            }
            catch (NoSuchElementException nsee) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("invalid_script_file", new String[]{this._scriptName, new Integer(lineNum).toString()}), nsee);
            }
            catch (AdminCommandException ae) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("invalid_admin_command", new String[]{this._scriptName, new Integer(lineNum).toString(), ae.getMessage()}), ae);
            }
            catch (Throwable t) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("script_command_error", new String[]{this._scriptName, new Integer(lineNum).toString(), t.getMessage()}), t);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (scriptReader == null) throw throwable;
            try {
                scriptReader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        scriptReader.close();
        return;
    }
}

