/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.cmdline.util.CommandOutputHelper;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ListApplicationsCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-listApplications";
    public static final String COMMANDMENU = "-listApplications [-verbose]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listApplications [-verbose]\n   - Displays the status of current deployed applications on OC4J instances.\n\nwhere the -verbose option is for displaying more details for applications.\n\n";
    private boolean _verbose = false;

    public ListApplicationsCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("listApplications subcommand");
            if (command.equalsIgnoreCase("-verbose")) {
                this._verbose = true;
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_listapplications_switch", new String[]{command}), COMMANDNAME);
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            Map apps = this._j2eeDeplMgr.getApplications(this._verbose);
            CommandOutputHelper.printMap(apps, "listApplications", this._verbose);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("listapplications_error", new String[]{e.getMessage()}), e);
        }
    }
}

