/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.ArrayList;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class CreateJDBCConnectionPoolCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-addDataSourceConnectionPool";
    public static final String APPNAME = "-applicationName";
    public static final String NAME = "-name";
    public static final String FACTORYCLASS = "-factoryClass";
    public static final String USER = "-dbUser";
    public static final String PASSWORD = "-dbPassword";
    public static final String URL = "-url";
    public static final String COMMANDMENU = "-addDataSourceConnectionPool  -name <name> -factoryClass <factoryClass> \n                              -dbUser <user> -dbPassword <password> -url <url> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addDataSourceConnectionPool\n   - Add a JDBC Connection Pool.\n\nValid switches are: \n   -applicationName <applicationName>                        - Required  The name of the application to deploy to.\n   -name <name>                                              - Required  The connection pool name.\n   -factoryClass <factoryClass>                              - Required  The fully qualified path of the conection factory implementation.\n   -dbUser <user>                                            - Required  The default user to use to get connections.\n   -dbPassword <password>                                    - Required  The default passwor to use to get connections.\n   -url <url>                                                - Required  The connection factory url to get connections.\n   -factoryProperties <name1> <value1> <name2> <value2> [..] - Optional  Property(ies) to set on the connection factory definition.\n\n";
    String _applicationName;
    String _name;
    String _factoryClass;
    String _user;
    String _password;
    String _url;
    List _properties = new ArrayList();

    public CreateJDBCConnectionPoolCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-addDataSourceConnectionPool subcommand");
            String nextArg = null;
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(NAME)) {
                this._name = this.getNextArgument("-name ");
                continue;
            }
            if (command.equalsIgnoreCase(FACTORYCLASS)) {
                this._factoryClass = this.getNextArgument("-factoryClass ");
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument("-dbUser ");
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument("-dbPassword ");
                continue;
            }
            if (command.equalsIgnoreCase(URL)) {
                this._url = this.getNextArgument("-url ");
                continue;
            }
            if (command.equalsIgnoreCase("-factoryProperties")) {
                while ((nextArg = this.readNextArgument()) != null && !nextArg.startsWith("-")) {
                    this._properties.add(this.getNextArgument("property name"));
                    this._properties.add(this.getNextArgument("property value"));
                }
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_createJDBCConnectionPool_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._name, NAME);
        this.checkArgIsNull(this._factoryClass, FACTORYCLASS);
        this.checkArgIsNull(this._user, USER);
        this.checkArgIsNull(this._password, PASSWORD);
        this.checkArgIsNull(this._url, URL);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.createJDBCConnectionPool(this._applicationName, this._name, this._factoryClass, this._user, this._password, this._url, this._properties);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("createJDBCConnectionPool_error", new String[]{e.getMessage()}), e);
        }
    }
}

