/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUtils;
import oracle.oc4j.admin.deploy.cmdline.ApplicationCommandInputValidator;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ApplicationStopCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-stop";
    public static final String COMMANDMENU = "-stop <appname> [-timeout <time in seconds>] [-graceful true|false]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -stop <appname> [-timeout <time in seconds>] [-graceful true|false]\n\n- Stops the specified application and its child application(s).\n- Timeout represents the amount of time for the application to shutdown gracefully. \n- Once timeout is reached the application will be stopped forcefully. \n- graceful by default is true. If set to false, application will not wait for in-flight requests to complete.\n\n";
    private String _appName;
    private Map _params;

    public ApplicationStopCommand(List args) throws AdminCommandException {
        super(args);
        this._appName = AdminCommandUtils.getNextArgument(args, "application name");
        String timeout = null;
        String graceful = null;
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("stop subcommand");
            if (command.equalsIgnoreCase("-timeout")) {
                timeout = AdminCommandUtils.getNextArgument(args, "-timeout");
                continue;
            }
            if (command.equalsIgnoreCase("-graceful")) {
                graceful = AdminCommandUtils.getNextArgument(args, "value for the -graceful");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_stop_switch", new String[]{command}), COMMANDNAME);
        }
        if (!this.isArgsEmpty()) {
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_stop_switch", new String[]{this.readNextArgument()}), COMMANDNAME);
        }
        this.validateInputs(timeout, graceful);
        this._params = ApplicationCommandInputValidator.addToParamsMap(timeout, graceful);
    }

    private void validateInputs(String timeout, String graceful) throws AdminCommandException {
        ApplicationCommandInputValidator.validateTimeout(timeout, COMMANDNAME);
        ApplicationCommandInputValidator.validateGracefulMode(graceful, COMMANDNAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.stopApplication(this._appName, this._params);
        }
        catch (Exception e) {
            throw new AdminCommandException(e.getMessage());
        }
    }

    protected Map getParams() {
        return this._params;
    }
}

