/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class AddJMSConnectionFactoryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-addJMSConnectionFactory";
    String _domain;
    String _location;
    String _host;
    String _port;
    String _username;
    String _password;
    String _clientID;
    Boolean _isXA = new Boolean("false");
    static final String COMMANDMENU = "-addJMSConnectionFactory -domain <domain> -jndiLocation <jndiLocation> [options]";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addJMSConnectionFactory\n   - Create a new OC4J JMS connection factory.\n\nValid switches are: \n   -domain <domain>                                    - Required  JMS domain of this connection factory (`QUEUE', `TOPIC', or `UNIFIED').\n   -jndiLocation <jndiLocation>                        - Required  JNDI location this connection factory will be bound to.\n   -host <host>                                        - Optional  The host name associated with this connection factory. (defaults to the containing OC4J JMS server host).\n   -port <port>                                        - Optional  The port number associated with this connection factory. (defaults to the containing OC4J JMS server port).\n   -username <username>                                - Optional  The user name associated with this connection factory. (defaults to the anonymous user).\n   -password <password>                                - Optional  The password associated with this connection factory. (defaults to null).\n   -clientID <clientID>                                - Optional  The JMS client ID associated with this connection factory. (defaults to null).\n   -isXA <isXA>                                        - Optional  Is this connection factory of an XA-flavor? (defaults to false).\n\n";

    public AddJMSConnectionFactoryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-addJMSConnectionFactory subcommand");
            if (command.equalsIgnoreCase("-domain")) {
                this._domain = this.getNextArgument("-domain");
                continue;
            }
            if (command.equalsIgnoreCase("-jndiLocation")) {
                this._location = this.getNextArgument("-jndiLocation");
                continue;
            }
            if (command.equalsIgnoreCase("-host")) {
                this._host = this.getNextArgument("-host");
                continue;
            }
            if (command.equalsIgnoreCase("-port")) {
                this._port = this.getNextArgument("-port");
                continue;
            }
            if (command.equalsIgnoreCase("-username")) {
                this._username = this.getNextArgument("-username ");
                continue;
            }
            if (command.equalsIgnoreCase("-password")) {
                this._password = this.getNextArgument("-password");
                continue;
            }
            if (command.equalsIgnoreCase("-clientID")) {
                this._clientID = this.getNextArgument("-clientID");
                continue;
            }
            if (command.equalsIgnoreCase("-isXA")) {
                this._isXA = new Boolean(this.getNextArgument("-isXA"));
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_addFactory_switch", new String[]{command}), "-addFactory");
        }
        this.checkArgIsNull(this._domain, "-domain");
        this.checkArgIsNull(this._location, "-location");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.addFactory(this._domain, this._location, this._host, this._port, this._username, this._password, this._clientID, this._isXA);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("addFactory_error", new String[]{e.getMessage()}), e);
        }
    }
}

