/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.shared;

import com.evermind.server.deployment.ResourceReference;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import oracle.oc4j.admin.management.shared.WebModuleLookupContext;

public class WebModuleResourceRefMapping
implements Serializable {
    WebModuleLookupContext m_webModuleLookupContext;
    String m_name;
    String m_location;

    public WebModuleResourceRefMapping() {
    }

    public WebModuleResourceRefMapping(ResourceReference ref) {
        this.m_name = ref.getName();
        this.m_location = ref.getLocation();
        Properties contextAttrs = ref.getContextAttributes();
        if (contextAttrs != null && !contextAttrs.isEmpty()) {
            this.m_webModuleLookupContext = new WebModuleLookupContext();
            this.m_webModuleLookupContext.setLocation((String)contextAttrs.get("context-location"));
            Properties newContextAttrs = new Properties();
            Enumeration<Object> keys = contextAttrs.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                newContextAttrs.setProperty(key, contextAttrs.getProperty(key));
            }
            newContextAttrs.remove("context-location");
            this.m_webModuleLookupContext.setContextAttributes(newContextAttrs);
        }
    }

    public WebModuleResourceRefMapping(WebModuleLookupContext webModuleLookupContext, String name, String location) {
        this.m_webModuleLookupContext = webModuleLookupContext;
        this.m_name = name;
        this.m_location = location;
    }

    public WebModuleLookupContext getWebModuleLookupContext() {
        return this.m_webModuleLookupContext;
    }

    public void setWebModuleLookupContext(WebModuleLookupContext value) {
        this.m_webModuleLookupContext = value;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String value) {
        this.m_location = value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("resource-ref-mapping: ");
        buf.append("\n");
        buf.append("  name: ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  location: ");
        buf.append(this.getLocation());
        buf.append("\n");
        buf.append(this.getWebModuleLookupContext());
        return buf.toString();
    }
}

