/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.shared;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.jmx.shared.MBeanServerConnectionListener;
import oracle.oc4j.admin.jmx.shared.RemoteListenerId;

public class JMSListenerAssociation {
    private static Logger logger_ = TraceLogger.getLogger((Class)JMSListenerAssociation.class);
    private static Hashtable localListenerToRemoteListenerIdAssociation_ = new Hashtable();
    private static Hashtable listenerToMBeanAssociation_ = new Hashtable();

    public static NotificationListener getListener(RemoteListenerId listenerId) {
        if (localListenerToRemoteListenerIdAssociation_ != null && listenerId != null) {
            return (NotificationListener)localListenerToRemoteListenerIdAssociation_.get(listenerId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListenerToMBeanAssociation(RemoteListenerId listenerId, ObjectName name, NotificationListener localListener) {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest("Adding association between MBean: " + name.toString() + " and listener with id: " + listenerId);
        }
        if (listenerId == null || name == null || localListener == null) {
            return;
        }
        Hashtable hashtable = listenerToMBeanAssociation_;
        synchronized (hashtable) {
            localListenerToRemoteListenerIdAssociation_.put(listenerId, localListener);
            HashSet<ObjectName> mbeans = (HashSet<ObjectName>)listenerToMBeanAssociation_.get(listenerId);
            if (mbeans == null) {
                mbeans = new HashSet<ObjectName>();
                mbeans.add(name);
                listenerToMBeanAssociation_.put(listenerId, mbeans);
            } else if (!mbeans.contains(name)) {
                mbeans.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListenerToMBeanAssociation(RemoteListenerId listenerId, ObjectName name) {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest("Removing association between MBean: " + name.toString() + " and listener with id: " + listenerId);
        }
        Hashtable hashtable = listenerToMBeanAssociation_;
        synchronized (hashtable) {
            Set mbeans = (Set)listenerToMBeanAssociation_.get(listenerId);
            if (mbeans != null && mbeans.contains(name)) {
                if (mbeans.size() == 1) {
                    listenerToMBeanAssociation_.remove(listenerId);
                    MBeanServerConnectionListener localListener = (MBeanServerConnectionListener)localListenerToRemoteListenerIdAssociation_.get(listenerId);
                    if (localListener != null) {
                        localListener.releaseResources();
                    }
                    localListenerToRemoteListenerIdAssociation_.remove(listenerId);
                } else {
                    mbeans.remove(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAllListeners(MBeanServer mbeanServer) {
        if (logger_.isLoggable(Level.FINEST)) {
            logger_.finest("Unregistering all listeners for MBeanServer: " + mbeanServer);
        }
        Hashtable hashtable = listenerToMBeanAssociation_;
        synchronized (hashtable) {
            if (listenerToMBeanAssociation_.isEmpty()) {
                return;
            }
            Enumeration listenersId = listenerToMBeanAssociation_.keys();
            while (listenersId.hasMoreElements()) {
                Set mbeans;
                RemoteListenerId listenerId = (RemoteListenerId)listenersId.nextElement();
                NotificationListener localListener = (NotificationListener)localListenerToRemoteListenerIdAssociation_.get(listenerId);
                if (localListener == null || (mbeans = (Set)listenerToMBeanAssociation_.get(listenerId)) == null) continue;
                Iterator iter = mbeans.iterator();
                while (iter.hasNext()) {
                    ObjectName mbeanName = (ObjectName)iter.next();
                    if (mbeanName == null) continue;
                    if (logger_.isLoggable(Level.FINEST)) {
                        logger_.finest("Unregistering listener: " + localListener + " for MBean: " + mbeanName + " and MBeanServer: " + mbeanServer);
                    }
                    try {
                        mbeanServer.removeNotificationListener(mbeanName, localListener);
                    }
                    catch (Throwable t) {
                        if (!logger_.isLoggable(Level.FINER)) continue;
                        logger_.log(Level.FINER, t.getMessage(), t);
                    }
                    finally {
                        ((MBeanServerConnectionListener)localListener).releaseResources();
                    }
                }
            }
            localListenerToRemoteListenerIdAssociation_ = new Hashtable();
            listenerToMBeanAssociation_ = new Hashtable();
        }
    }
}

