/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.client;

import java.util.StringTokenizer;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jApplicationLevelDomain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;

public class JMSOc4jDomainFactory {
    public static Domain getDomain(String host, int port, String login, String pwd) {
        return new JMSOc4jDomain(host, port, login, pwd);
    }

    public static Domain getDomain(String host, int port, String login, String pwd, String appName) {
        return new JMSOc4jApplicationLevelDomain(host, port, login, pwd, appName);
    }

    public static Domain getDomain(String host, int port) {
        return new JMSOc4jDomain(host, port);
    }

    public static Domain getDomain(String host, int port, String appName) {
        return new JMSOc4jApplicationLevelDomain(host, port, appName);
    }

    public static Domain getDomain(String domain) {
        if (domain.indexOf("default") != -1) {
            return new JMSOc4jApplicationLevelDomain(domain);
        }
        return new JMSOc4jDomain(domain);
    }

    public static Domain getDomain(String domain, String login, String pwd) {
        if (domain.indexOf("default") != -1) {
            return new JMSOc4jApplicationLevelDomain(domain, login, pwd);
        }
        return new JMSOc4jDomain(domain, login, pwd);
    }

    public static Domain getDomainFromDeployerUrl(String deployerUrl, String login, String pwd) {
        StringTokenizer strTok = new StringTokenizer(deployerUrl, ":");
        if (strTok.countTokens() < 1) {
            throw new IllegalArgumentException("Invalid deployer url: " + deployerUrl);
        }
        if (strTok.countTokens() == 1) {
            return new JMSOc4jDomain("localhost", 23791, login, pwd);
        }
        strTok.nextToken();
        strTok.nextToken();
        String host = strTok.nextToken();
        int port = 23791;
        if (strTok.countTokens() > 0) {
            port = Integer.parseInt(strTok.nextToken());
        }
        return new JMSOc4jDomain(host, port, login, pwd);
    }

    public static Domain getDomainFromJmx4antUrl(String url, String login, String pwd) {
        if (url == null) {
            throw new IllegalArgumentException("JMX url cannot be null");
        }
        if (!url.startsWith("jmx://") && !url.startsWith("JMX://")) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        if (url.length() < 7) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        String hostPort = url.substring(6);
        StringTokenizer strTok = new StringTokenizer(hostPort, ":");
        if (strTok.countTokens() < 2) {
            throw new IllegalArgumentException("Invalid JMX url. The url must be of the form jmx://host:port");
        }
        String host = strTok.nextToken();
        int port = Integer.parseInt(strTok.nextToken());
        if (strTok.countTokens() > 0) {
            String appName = strTok.nextToken();
            return JMSOc4jDomainFactory.getDomain(host, port, login, pwd, appName);
        }
        return JMSOc4jDomainFactory.getDomain(host, port, login, pwd);
    }
}

