/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.TabFilterOutputStream;
import oracle.oc4j.admin.deploy.spi.xml.XmlType;

public class XmlTypePanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static Logger logger_ = TraceLogger.getLogger((Class)XmlTypePanel.class);
    private PropertyEditorSupport _editor;
    private Method _method;
    private ConfigBeanNode _bean = null;
    private ByteArrayOutputStream _byteOutput = null;
    private TabFilterOutputStream _filterStrm = null;
    private PrintWriter _writer = null;
    private JTextArea _textArea = null;

    public XmlTypePanel(PropertyEditorSupport editor) {
        this(editor, null);
    }

    public XmlTypePanel(PropertyEditorSupport editor, Method method) {
        this._editor = editor;
        this._method = method;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.init();
    }

    private void init() {
        try {
            this._textArea = new JTextArea();
            this.updateXML();
            this._textArea.setEditable(false);
            JScrollPane sp = new JScrollPane(this._textArea);
            this.setLayout(new BoxLayout(this, 1));
            this.add(sp);
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.updateXML();
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateXML();
    }

    public void updateXML() {
        XmlType xmlType = (XmlType)this._editor.getValue();
        this._bean = xmlType.getSource();
        this._byteOutput = new ByteArrayOutputStream();
        this._filterStrm = new TabFilterOutputStream(this._byteOutput);
        try {
            this._writer = new PrintWriter(new OutputStreamWriter((OutputStream)this._filterStrm, "UTF-8"));
        }
        catch (UnsupportedEncodingException unEx) {
            this._writer = new PrintWriter(this._filterStrm);
        }
        if (this._method != null) {
            try {
                this._method.invoke((Object)this._bean, this._writer, "");
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.SEVERE)) {
                    logger_.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        } else {
            this._bean.writeXML(this._writer, "");
        }
        this._writer.flush();
        this._writer.close();
        try {
            this._textArea.setText(this._byteOutput.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException unEx) {
            this._textArea.setText(this._byteOutput.toString());
        }
    }
}

