/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SerializersTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TypeMappingType;

public class TypeMappingTreeNode
extends ConfigTreeNode
implements ActionListener {
    private TypeMappingType _bean;
    private static final String REMOVE_TYPE_MAPPING_MENU_STRING = "Remove Type Mapping";
    private JMenuItem _removeTypeMappingMenuItem;

    public TypeMappingTreeNode(ConfigTreeNode rootNode, TypeMappingType typeMapping) {
        super(typeMapping);
        this.setRootNode(rootNode);
        this._bean = typeMapping;
        this._removeTypeMappingMenuItem = new JMenuItem(REMOVE_TYPE_MAPPING_MENU_STRING);
        this._removeTypeMappingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeTypeMappingMenuItem.setFont(TypeMappingTreeNode.getFont());
        this._removeTypeMappingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._removeTypeMappingMenuItem);
    }

    public String viewHeaderString() {
        return "Type Mapping";
    }

    public String toString() {
        return this._bean.getXmlType();
    }

    protected void buildChildJTree() {
        try {
            Method xmlMethod = TypeMappingType.class.getMethod("writeSerializersXML", PrintWriter.class, String.class);
            SerializersTreeNode serializersTreeNode = new SerializersTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(serializersTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(REMOVE_TYPE_MAPPING_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }
}

